function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/client/renderer/LevelRenderer',
		'methodName' : resolveName('m_109703_'), // renderSnowAndRain
		'methodDesc' : '(Lnet/minecraft/client/renderer/LightTexture;FDDD)V'
	}

	var node = {
		'class' : 'com/mojang/blaze3d/systems/RenderSystem',
		'methodName' : resolveName('m_157456_'), // setShaderTexture
		'methodDesc' : '(ILnet/minecraft/resources/ResourceLocation;)V'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/renderers/AcidRain',
		'methodName' : 'onVanillaTextureBinding',
		'methodDesc' : '()V'
	}

	var instructions = [ 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}