function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
		'coremods/core_functions.js')

	var target = {
		'type': 'METHOD',
		'class': 'flaxbeard/immersivepetroleum/common/entity/MotorboatEntity',
		'methodName': resolveName('func_184443_x'), // controlBoat
		'methodDesc': '()V'
	}

	var node = {
		'class': 'flaxbeard/immersivepetroleum/common/entity/MotorboatEntity',
		'methodName': 'setContainedFluid',
		'methodDesc': '(Lnet/minecraftforge/fluids/FluidStack;)V'
	}

	var getFuelBefore = {
		'class': 'flaxbeard/immersivepetroleum/common/entity/MotorboatEntity',
		'methodName': 'getContainedFluid',
		'methodDesc': '()Lnet/minecraftforge/fluids/FluidStack;'
	}

	var handler = {
		'class': 'com/endertech/minecraft/mods/adpother/compat/ImmersivePetroleum$Motorboat',
		'methodName': 'onFuelBurned',
		'methodDesc': '(Lnet/minecraft/world/entity/Entity;Lnet/minecraftforge/fluids/FluidStack;Lnet/minecraftforge/fluids/FluidStack;)V'
	}

	var alignment = {
		'class': 'com/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment',
		'fieldName': 'CENTER',
		'fieldDesc': 'Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;'
	}

	var instructions = [
		insnDup2("boat, fuelNow"),
		insnLoadThis("boat"),
		insnInvokeVirtual(getFuelBefore),
		insnCallHandler(handler)
	];

	return {
		'coremod': {
			'target': target,
			'transformer': function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}