function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/world/level/material/FluidState',
		'methodName' : resolveName('m_76174_'), // randomTick
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Ljava/util/Random;)V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/forge/events/RandomTickEvent',
		'methodName' : 'onRandomTickFluid',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/material/FluidState;)Z'
	}

	var instructions = [
	    insnLoadObj(1, "level"),
	    insnLoadObj(2, "pos"),
	    insnLoadObj(0, "state"),
	    insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions.concat(instructionsIfTrueReturn()));
				return method;
			}
		}
	}
}