/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.vertex;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.core.vertex.PosTexNormalVertex;
import com.jozufozu.flywheel.core.vertex.VertexWriterUnsafe;
import com.jozufozu.flywheel.util.RenderMath;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public class PosTexNormalWriterUnsafe
extends VertexWriterUnsafe<PosTexNormalVertex> {
    public PosTexNormalWriterUnsafe(PosTexNormalVertex type, ByteBuffer buffer) {
        super(type, buffer);
    }

    @Override
    public void writeVertex(VertexList list, int i) {
        float x = list.getX(i);
        float y = list.getY(i);
        float z = list.getZ(i);
        float u = list.getU(i);
        float v = list.getV(i);
        float xN = list.getNX(i);
        float yN = list.getNY(i);
        float zN = list.getNZ(i);
        this.putVertex(x, y, z, xN, yN, zN, u, v);
    }

    public void putVertex(float x, float y, float z, float nX, float nY, float nZ, float u, float v) {
        MemoryUtil.memPutFloat((long)this.ptr, (float)x);
        MemoryUtil.memPutFloat((long)(this.ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(this.ptr + 8L), (float)z);
        MemoryUtil.memPutFloat((long)(this.ptr + 12L), (float)u);
        MemoryUtil.memPutFloat((long)(this.ptr + 16L), (float)v);
        MemoryUtil.memPutByte((long)(this.ptr + 20L), (byte)RenderMath.nb(nX));
        MemoryUtil.memPutByte((long)(this.ptr + 21L), (byte)RenderMath.nb(nY));
        MemoryUtil.memPutByte((long)(this.ptr + 22L), (byte)RenderMath.nb(nZ));
        this.ptr += 23L;
        this.advance();
    }
}

