/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonHelper {
    public static NonNullList<ItemStack> readItemStackList(JsonArray resultArray) {
        NonNullList results = NonNullList.m_122779_();
        for (JsonElement result : resultArray) {
            results.add((Object)CraftingHelper.getItemStack((JsonObject)result.getAsJsonObject(), (boolean)true));
        }
        return results;
    }

    public static List<Potion> readPotionList(JsonArray resultArray) {
        ArrayList<Potion> results = new ArrayList<Potion>();
        for (JsonElement result : resultArray) {
            String id = GsonHelper.m_13906_((JsonObject)result.getAsJsonObject(), (String)"id");
            results.add(JsonHelper.getPotion(new ResourceLocation(id)));
        }
        return results;
    }

    public static Potion getPotion(ResourceLocation potionName) {
        Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(potionName);
        if (potion == null) {
            throw new JsonSyntaxException("Unknown potion '" + potionName + "'");
        }
        return potion;
    }

    public static MobEffect getEffect(ResourceLocation effectName) {
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectName);
        if (effect == null) {
            throw new JsonSyntaxException("Unknown effect '" + effectName + "'");
        }
        return effect;
    }
}

