/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.pavocado.exoticbirds.blockentity.BirdcageBlockEntity;
import net.pavocado.exoticbirds.network.PacketLogBird;

public class PacketLogBirdcage {
    private final BlockPos cagePos;
    private final boolean isNewEntry;

    public PacketLogBirdcage(BlockPos cagePos, boolean isNewEntry) {
        this.cagePos = cagePos;
        this.isNewEntry = isNewEntry;
    }

    public static void encode(PacketLogBirdcage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.cagePos);
        buffer.writeBoolean(message.isNewEntry);
    }

    public static PacketLogBirdcage decode(FriendlyByteBuf buffer) {
        return new PacketLogBirdcage(buffer.m_130135_(), buffer.readBoolean());
    }

    public static void handle(PacketLogBirdcage packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketLogBirdcage.handleOnClient(packet)));
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(PacketLogBirdcage packet) {
        BlockEntity blockEntity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (blockEntity = player.f_19853_.m_7702_(packet.cagePos)) instanceof BirdcageBlockEntity) {
            BirdcageBlockEntity birdcageBlockEntity = (BirdcageBlockEntity)blockEntity;
            Entity entity = birdcageBlockEntity.getBirdcageLogic().getOrCreateDisplayEntity(player.f_19853_);
            PacketLogBird.displayLoggedBirdInfo(player, entity, packet.isNewEntry);
        }
    }
}

