/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;
import net.pavocado.exoticbirds.ExoticBirdsMod;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;

public class BirdcageItem
extends BlockItem {
    private Entity cachedEntity;

    public BirdcageItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (player.f_19853_.f_46443_) {
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        if (!target.m_6084_() || target instanceof Player) {
            return InteractionResult.PASS;
        }
        if (!BirdcageItem.cageEmpty(stack)) {
            player.m_5661_((Component)new TranslatableComponent("cage.exoticbirds.cage_full"), true);
        } else if (!(target instanceof AbstractBirdEntity) && !((Boolean)ExoticBirdsCommonConfig.allowAnythingInCages.get()).booleanValue()) {
            player.m_5661_((Component)new TranslatableComponent("cage.exoticbirds.cage_only_birds"), true);
        } else if (target instanceof Monster) {
            player.m_5661_((Component)new TranslatableComponent("cage.exoticbirds.cage_no_monsters"), true);
        } else if (target instanceof TamableAnimal && ((TamableAnimal)target).m_21824_() && !((TamableAnimal)target).m_21830_((LivingEntity)player)) {
            player.m_5661_((Component)new TranslatableComponent("cage.exoticbirds.cage_not_own_pet"), true);
        } else {
            target.m_8127_();
            target.m_20153_();
            CompoundTag entityTag = new CompoundTag();
            if (target.m_20223_(entityTag)) {
                entityTag.m_128473_("Motion");
                entityTag.m_128473_("Dimension");
                entityTag.m_128473_("Rotation");
                entityTag.m_128473_("Pos");
                entityTag.m_128473_("UUID");
                stack.m_41700_("CageData", (Tag)entityTag);
                target.m_142687_(Entity.RemovalReason.DISCARDED);
                player.m_21008_(hand, stack);
            }
        }
        return InteractionResult.CONSUME;
    }

    public static boolean cageEmpty(ItemStack stack) {
        return stack.m_41737_("CageData") == null;
    }

    public static CompoundTag getCageData(ItemStack stack) {
        return stack.m_41737_("CageData");
    }

    public String m_5671_(ItemStack stack) {
        if (stack.m_41737_("CageData") != null) {
            return this.m_5524_() + ".full";
        }
        return super.m_5671_(stack);
    }

    public static int getColor(ItemStack stack, int index) {
        if (!BirdcageItem.cageEmpty(stack) && index > 0) {
            SpawnEggItem egg;
            EntityType entity = (EntityType)ExoticBirdsEntities.FLAMINGO.get();
            CompoundTag cageData = stack.m_41737_("CageData");
            if (cageData != null && cageData.m_128425_("id", 8)) {
                ResourceLocation entityId = new ResourceLocation(cageData.m_128461_("id"));
                entity = (EntityType)ForgeRegistries.ENTITIES.getValue(entityId);
            }
            if ((egg = ForgeSpawnEggItem.fromEntityType((EntityType)entity)) != null) {
                return egg.m_43211_(index - 1);
            }
        }
        return 0xFFFFFF;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag cageData = stack.m_41737_("CageData");
        if (cageData != null) {
            ResourceLocation entityId;
            EntityType entity;
            if (cageData.m_128425_("id", 8) && (entity = (EntityType)ForgeRegistries.ENTITIES.getValue(entityId = new ResourceLocation(cageData.m_128461_("id")))) != null) {
                tooltip.add((Component)new TranslatableComponent(entity.m_20675_()).m_130940_(ChatFormatting.YELLOW));
                if (!(level == null || this.cachedEntity != null && cageData.m_128461_("id").equals(this.cachedEntity.m_20078_()))) {
                    this.cachedEntity = entity.m_20615_(level);
                }
                if (this.cachedEntity instanceof AbstractBirdEntity) {
                    BaseComponent variantName = ((AbstractBirdEntity)this.cachedEntity).getTranslatedVariantName(cageData.m_128451_("Variant"), true);
                    tooltip.add((Component)new TranslatableComponent("egg.exoticbirds.variant", new Object[]{variantName}).m_130940_(ChatFormatting.GRAY));
                }
            }
            if (cageData.m_128425_("CustomName", 8)) {
                String s = cageData.m_128461_("CustomName");
                try {
                    tooltip.add((Component)new TranslatableComponent("cage.exoticbirds.name", new Object[]{Component.Serializer.m_130701_((String)s)}).m_130940_(ChatFormatting.GRAY));
                }
                catch (Exception exception) {
                    ExoticBirdsMod.LOGGER.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
                }
            }
            if (cageData.m_128425_("Health", 99)) {
                tooltip.add((Component)new TranslatableComponent("cage.exoticbirds.health", new Object[]{Float.valueOf(cageData.m_128457_("Health") * 0.5f)}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

