/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.entity.ai.BirdBreedGoal;
import net.pavocado.exoticbirds.entity.ai.LayEggInNestGoal;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockTags;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSoundEvents;

public class PenguinEntity
extends AbstractBirdEntity {
    public float penguinPitch;
    public float prevPenguinPitch;
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/penguin/penguin_emperor.png")));
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(PenguinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<BlockPos> TRAVEL_POS = SynchedEntityData.m_135353_(PenguinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> GOING_HOME = SynchedEntityData.m_135353_(PenguinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TRAVELLING = SynchedEntityData.m_135353_(PenguinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public PenguinEntity(EntityType<? extends PenguinEntity> type, Level level) {
        super(type, level, new ItemStack((ItemLike)ExoticBirdsItems.PENGUIN_EGG.get()), BIRD_TEXTURES.size(), false, false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, -1.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, -1.0f);
        this.m_21441_(BlockPathTypes.DOOR_OPEN, -1.0f);
        this.f_19793_ = 1.0f;
        this.f_21342_ = new PenguinMoveControl(this);
        this.hasChildTextures = true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PenguinPanicGoal(this, 1.4));
        this.f_21345_.m_25352_(1, (Goal)new BirdBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new LayEggInNestGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new PenguinGoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new PenguinGoHomeGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new PenguinTravelGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new PenguinRandomStrollGoal(this, 1.0, 100));
    }

    protected PathNavigation m_6037_(Level p_30171_) {
        return new PenguinPathNavigation(this, p_30171_);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return this.m_6162_() ? size.f_20378_ * 0.8f : size.f_20378_ * 0.85f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_PENGUIN_AMBIENT.get();
    }

    public PenguinEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        PenguinEntity penguin = (PenguinEntity)((EntityType)ExoticBirdsEntities.PENGUIN.get()).m_20615_((Level)serverLevel);
        penguin.setVariant(this.getChildVariant());
        return penguin;
    }

    @Override
    protected void performFlap() {
        super.performFlap();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.m_6210_();
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.25f;
    }

    public void setHomePos(BlockPos p_30220_) {
        this.f_19804_.m_135381_(HOME_POS, (Object)p_30220_);
    }

    BlockPos getHomePos() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    void setTravelPos(BlockPos p_30224_) {
        this.f_19804_.m_135381_(TRAVEL_POS, (Object)p_30224_);
    }

    BlockPos getTravelPos() {
        return (BlockPos)this.f_19804_.m_135370_(TRAVEL_POS);
    }

    boolean isGoingHome() {
        return (Boolean)this.f_19804_.m_135370_(GOING_HOME);
    }

    void setGoingHome(boolean p_30239_) {
        this.f_19804_.m_135381_(GOING_HOME, (Object)p_30239_);
    }

    boolean isTravelling() {
        return (Boolean)this.f_19804_.m_135370_(TRAVELLING);
    }

    void setTravelling(boolean p_30241_) {
        this.f_19804_.m_135381_(TRAVELLING, (Object)p_30241_);
    }

    public boolean m_6573_(Player p_30151_) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.prevPenguinPitch = this.penguinPitch;
        Vec3 vec3 = this.m_20184_();
        double d0 = vec3.m_165924_();
        this.penguinPitch = this.m_20069_() ? (this.penguinPitch += (-((float)Mth.m_14136_((double)d0, (double)vec3.f_82480_)) * 57.295776f - this.penguinPitch) * 0.1f) : (float)((double)this.penguinPitch - (double)this.penguinPitch * 0.2);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOME_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(TRAVEL_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(GOING_HOME, (Object)false);
        this.f_19804_.m_135372_(TRAVELLING, (Object)false);
    }

    public void m_7023_(Vec3 p_30218_) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.1f, p_30218_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!(this.m_5448_() != null || this.isGoingHome() && this.getHomePos().m_203195_((Position)this.m_20182_(), 20.0))) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_30218_);
        }
    }

    @Override
    public void m_7380_(CompoundTag p_30176_) {
        super.m_7380_(p_30176_);
        p_30176_.m_128405_("HomePosX", this.getHomePos().m_123341_());
        p_30176_.m_128405_("HomePosY", this.getHomePos().m_123342_());
        p_30176_.m_128405_("HomePosZ", this.getHomePos().m_123343_());
        p_30176_.m_128405_("TravelPosX", this.getTravelPos().m_123341_());
        p_30176_.m_128405_("TravelPosY", this.getTravelPos().m_123342_());
        p_30176_.m_128405_("TravelPosZ", this.getTravelPos().m_123343_());
    }

    @Override
    public void m_7378_(CompoundTag p_30162_) {
        int i = p_30162_.m_128451_("HomePosX");
        int j = p_30162_.m_128451_("HomePosY");
        int k = p_30162_.m_128451_("HomePosZ");
        this.setHomePos(new BlockPos(i, j, k));
        super.m_7378_(p_30162_);
        int l = p_30162_.m_128451_("TravelPosX");
        int i1 = p_30162_.m_128451_("TravelPosY");
        int j1 = p_30162_.m_128451_("TravelPosZ");
        this.setTravelPos(new BlockPos(l, i1, j1));
    }

    public boolean m_6040_() {
        return true;
    }

    public float m_5610_(BlockPos p_30159_, LevelReader p_30160_) {
        if (!this.isGoingHome() && p_30160_.m_6425_(p_30159_).m_205070_(FluidTags.f_13131_)) {
            return 10.0f;
        }
        return p_30160_.m_46863_(p_30159_) - 0.5f;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        if (this.m_20069_()) {
            return super.m_6972_(poseIn).m_20390_(1.2f, 0.3f);
        }
        return super.m_6972_(poseIn);
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return (List)ExoticBirdsCommonConfig.blacklistedDimensionsPenguin.get();
    }

    @Override
    public List<ItemStack> getTemptingItems() {
        return Arrays.asList(FOOD_ITEMS.m_43908_());
    }

    public static boolean checkPenguinSpawnRules(EntityType<PenguinEntity> p_218250_, LevelAccessor p_218251_, MobSpawnType p_218252_, BlockPos p_218253_, Random p_218254_) {
        return PenguinEntity.m_186209_((BlockAndTintGetter)p_218251_, (BlockPos)p_218253_) && p_218251_.m_8055_(p_218253_.m_7495_()).m_204336_(ExoticBirdsBlockTags.PENGUINS_SPAWNABLE_ON);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        if (!(spawnData instanceof AbstractBirdEntity.BirdGroupData)) {
            spawnData = new AbstractBirdEntity.BirdGroupData((AbstractBirdEntity)this, 1.0f);
        }
        this.setHomePos(this.m_142538_());
        this.setTravelPos(BlockPos.f_121853_);
        return super.m_6518_(level, difficulty, reason, (SpawnGroupData)spawnData, tag);
    }

    static class PenguinMoveControl
    extends MoveControl {
        private final PenguinEntity penguin;

        PenguinMoveControl(PenguinEntity penguinIn) {
            super((Mob)penguinIn);
            this.penguin = penguinIn;
        }

        private void updateSpeed() {
            if (this.penguin.m_20069_()) {
                this.penguin.m_20256_(this.penguin.m_20184_().m_82520_(0.0, 0.005, 0.0));
                if (!this.penguin.getHomePos().m_203195_((Position)this.penguin.m_20182_(), 16.0)) {
                    this.penguin.m_7910_(Math.max(this.penguin.m_6113_() / 2.0f, 0.08f));
                }
                if (this.penguin.m_6162_()) {
                    this.penguin.m_7910_(Math.max(this.penguin.m_6113_() / 3.0f, 0.06f));
                }
            } else if (this.penguin.f_19861_) {
                this.penguin.m_7910_(Math.max(this.penguin.m_6113_() / 2.0f, 0.12f));
            }
        }

        public void m_8126_() {
            this.updateSpeed();
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.penguin.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.penguin.m_20185_();
                double d1 = this.f_24976_ - this.penguin.m_20186_();
                double d2 = this.f_24977_ - this.penguin.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.penguin.m_146922_(this.m_24991_(this.penguin.m_146908_(), f, 90.0f));
                this.penguin.f_20883_ = this.penguin.m_146908_();
                float f1 = (float)(this.f_24978_ * this.penguin.m_21133_(Attributes.f_22279_));
                this.penguin.m_7910_(Mth.m_14179_((float)0.125f, (float)this.penguin.m_6113_(), (float)f1));
                this.penguin.m_20256_(this.penguin.m_20184_().m_82520_(0.0, (double)this.penguin.m_6113_() * d1 * 0.1, 0.0));
            } else {
                this.penguin.m_7910_(0.0f);
            }
        }
    }

    static class PenguinPanicGoal
    extends PanicGoal {
        PenguinPanicGoal(PenguinEntity p_30290_, double p_30291_) {
            super((PathfinderMob)p_30290_, p_30291_);
        }

        public boolean m_8036_() {
            if (this.f_25684_.m_142581_() == null && !this.f_25684_.m_6060_()) {
                return false;
            }
            BlockPos blockpos = this.m_198172_((BlockGetter)this.f_25684_.f_19853_, (Entity)this.f_25684_, 7);
            if (blockpos != null) {
                this.f_25686_ = blockpos.m_123341_();
                this.f_25687_ = blockpos.m_123342_();
                this.f_25688_ = blockpos.m_123343_();
                return true;
            }
            return this.m_25702_();
        }
    }

    static class PenguinGoToWaterGoal
    extends MoveToBlockGoal {
        private static final int GIVE_UP_TICKS = 1200;
        private final PenguinEntity penguin;

        PenguinGoToWaterGoal(PenguinEntity p_30262_, double p_30263_) {
            super((PathfinderMob)p_30262_, p_30262_.m_6162_() ? 2.0 : p_30263_, 24);
            this.penguin = p_30262_;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return !this.penguin.m_20069_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.penguin.f_19853_, this.f_25602_);
        }

        public boolean m_8036_() {
            if (this.penguin.m_6162_() && !this.penguin.m_20069_()) {
                return super.m_8036_();
            }
            return !this.penguin.isGoingHome() && !this.penguin.m_20069_() && super.m_8036_();
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader p_30270_, BlockPos p_30271_) {
            return p_30270_.m_8055_(p_30271_).m_60713_(Blocks.f_49990_);
        }
    }

    static class PenguinGoHomeGoal
    extends Goal {
        private final PenguinEntity penguin;
        private final double speedModifier;
        private boolean stuck;
        private int closeToHomeTryTicks;
        private static final int GIVE_UP_TICKS = 600;

        PenguinGoHomeGoal(PenguinEntity p_30253_, double p_30254_) {
            this.penguin = p_30253_;
            this.speedModifier = p_30254_;
        }

        public boolean m_8036_() {
            if (this.penguin.m_6162_()) {
                return false;
            }
            if (this.penguin.m_21187_().nextInt(PenguinGoHomeGoal.m_186073_((int)700)) != 0) {
                return false;
            }
            return !this.penguin.getHomePos().m_203195_((Position)this.penguin.m_20182_(), 64.0);
        }

        public void m_8056_() {
            this.penguin.setGoingHome(true);
            this.stuck = false;
            this.closeToHomeTryTicks = 0;
        }

        public void m_8041_() {
            this.penguin.setGoingHome(false);
        }

        public boolean m_8045_() {
            return !this.penguin.getHomePos().m_203195_((Position)this.penguin.m_20182_(), 7.0) && !this.stuck && this.closeToHomeTryTicks <= this.m_183277_(600);
        }

        public void m_8037_() {
            BlockPos blockpos = this.penguin.getHomePos();
            boolean flag = blockpos.m_203195_((Position)this.penguin.m_20182_(), 16.0);
            if (flag) {
                ++this.closeToHomeTryTicks;
            }
            if (this.penguin.m_21573_().m_26571_()) {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)blockpos);
                Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.penguin, (int)16, (int)3, (Vec3)vec3, (double)0.3141592741012573);
                if (vec31 == null) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.penguin, (int)8, (int)7, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 != null && !flag && !this.penguin.f_19853_.m_8055_(new BlockPos(vec31)).m_60713_(Blocks.f_49990_)) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.penguin, (int)16, (int)5, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 == null) {
                    this.stuck = true;
                    return;
                }
                this.penguin.m_21573_().m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
            }
        }
    }

    static class PenguinTravelGoal
    extends Goal {
        private final PenguinEntity penguin;
        private final double speedModifier;
        private boolean stuck;

        PenguinTravelGoal(PenguinEntity p_30333_, double p_30334_) {
            this.penguin = p_30333_;
            this.speedModifier = p_30334_;
        }

        public boolean m_8036_() {
            return !this.penguin.isGoingHome() && this.penguin.m_20069_();
        }

        public void m_8056_() {
            int i = 512;
            int j = 4;
            Random random = this.penguin.f_19796_;
            int k = random.nextInt(1025) - 512;
            int l = random.nextInt(9) - 4;
            int i1 = random.nextInt(1025) - 512;
            if ((double)l + this.penguin.m_20186_() > (double)(this.penguin.f_19853_.m_5736_() - 1)) {
                l = 0;
            }
            BlockPos blockpos = new BlockPos((double)k + this.penguin.m_20185_(), (double)l + this.penguin.m_20186_(), (double)i1 + this.penguin.m_20189_());
            this.penguin.setTravelPos(blockpos);
            this.penguin.setTravelling(true);
            this.stuck = false;
        }

        public void m_8037_() {
            if (this.penguin.m_21573_().m_26571_()) {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)this.penguin.getTravelPos());
                Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.penguin, (int)16, (int)3, (Vec3)vec3, (double)0.3141592741012573);
                if (vec31 == null) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.penguin, (int)8, (int)7, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 != null) {
                    int i = Mth.m_14107_((double)vec31.f_82479_);
                    int j = Mth.m_14107_((double)vec31.f_82481_);
                    int k = 34;
                    if (!this.penguin.f_19853_.m_151572_(i - 34, j - 34, i + 34, j + 34)) {
                        vec31 = null;
                    }
                }
                if (vec31 == null) {
                    this.stuck = true;
                    return;
                }
                this.penguin.m_21573_().m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
            }
        }

        public boolean m_8045_() {
            return !this.penguin.m_21573_().m_26571_() && !this.stuck && !this.penguin.isGoingHome() && !this.penguin.m_27593_();
        }

        public void m_8041_() {
            this.penguin.setTravelling(false);
            super.m_8041_();
        }
    }

    static class PenguinRandomStrollGoal
    extends RandomStrollGoal {
        private final PenguinEntity penguin;

        PenguinRandomStrollGoal(PenguinEntity p_30303_, double p_30304_, int p_30305_) {
            super((PathfinderMob)p_30303_, p_30304_, p_30305_);
            this.penguin = p_30303_;
        }

        public boolean m_8036_() {
            return !this.f_25725_.m_20069_() && !this.penguin.isGoingHome() ? super.m_8036_() : false;
        }
    }

    static class PenguinPathNavigation
    extends WaterBoundPathNavigation {
        PenguinPathNavigation(PenguinEntity p_30294_, Level p_30295_) {
            super((Mob)p_30294_, p_30295_);
        }

        protected boolean m_7632_() {
            return true;
        }

        protected PathFinder m_5532_(int p_30298_) {
            this.f_26508_ = new AmphibiousNodeEvaluator(true);
            return new PathFinder(this.f_26508_, p_30298_);
        }

        public boolean m_6342_(BlockPos p_30300_) {
            PenguinEntity penguin;
            Mob mob = this.f_26494_;
            if (mob instanceof PenguinEntity && (penguin = (PenguinEntity)mob).isTravelling()) {
                return this.f_26495_.m_8055_(p_30300_).m_60713_(Blocks.f_49990_);
            }
            return !this.f_26495_.m_8055_(p_30300_.m_7495_()).m_60795_();
        }
    }
}

