/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.entity.ai.BirdBreedGoal;
import net.pavocado.exoticbirds.entity.ai.LayEggInNestGoal;
import net.pavocado.exoticbirds.entity.ai.TameOstrichGoal;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSoundEvents;

public class OstrichEntity
extends AbstractBirdEntity
implements PlayerRideableJumping,
Saddleable,
IForgeShearable {
    private static final EntityDataAccessor<Boolean> DATA_SADDLED = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_, Items.f_42732_, Items.f_42780_, Items.f_41952_, Items.f_41953_});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/ostrich/ostrich_common_male.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/ostrich/ostrich_common_female.png"));
    });
    protected float playerJumpPendingScale;
    protected boolean isJumping;
    protected int temper;

    public OstrichEntity(EntityType<? extends OstrichEntity> type, Level level) {
        super(type, level, new ItemStack((ItemLike)ExoticBirdsItems.OSTRICH_EGG.get()), BIRD_TEXTURES.size(), false, true);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.hasChildTextures = true;
        this.f_19793_ = 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BirdBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(1, (Goal)new TameOstrichGoal(this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new LayEggInNestGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SADDLED, (Object)false);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return this.m_6162_() ? size.f_20378_ * 0.85f : size.f_20378_ * 0.92f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22288_, 0.7);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_OSTRICH_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_OSTRICH_HURT.get();
    }

    public OstrichEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        OstrichEntity ostrich = (OstrichEntity)((EntityType)ExoticBirdsEntities.OSTRICH.get()).m_20615_((Level)serverLevel);
        ostrich.setVariant(this.getChildVariant());
        return ostrich;
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Saddle", this.m_6254_());
        tag.m_128405_("Temper", this.getTemper());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSaddle(tag.m_128471_("Saddle"));
        this.setTemper(tag.m_128451_("Temper"));
    }

    public void setSaddle(boolean saddle) {
        this.f_19804_.m_135381_(DATA_SADDLED, (Object)saddle);
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    public boolean m_5807_() {
        return this.m_6688_() instanceof Player;
    }

    public double m_6048_() {
        if (this.m_6254_()) {
            return (double)this.m_6972_((Pose)Pose.STANDING).f_20378_ / 2.0 + (double)0.105f;
        }
        return (double)this.m_6972_((Pose)Pose.STANDING).f_20378_ / 2.0;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.m_6162_() && this.m_20160_()) {
            return super.m_6071_(player, hand);
        }
        if (!itemstack.m_41619_()) {
            if (this.m_6898_(itemstack)) {
                return super.m_6071_(player, hand);
            }
            InteractionResult interactionresult = itemstack.m_41647_(player, (LivingEntity)this, hand);
            if (interactionresult.m_19077_()) {
                return interactionresult;
            }
            if (!this.m_6162_() && !this.m_6254_() && itemstack.m_150930_(Items.f_42450_)) {
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        if (this.m_6162_()) {
            return super.m_6071_(player, hand);
        }
        if (((Boolean)ExoticBirdsCommonConfig.allowOstrichRiding.get()).booleanValue()) {
            this.doPlayerRide(player);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.setSaddle(true);
        if (soundSource != null) {
            this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12236_, soundSource, 0.5f, 1.0f);
        }
    }

    protected void doPlayerRide(Player p_30634_) {
        if (!this.f_19853_.f_46443_) {
            p_30634_.m_146922_(this.m_146908_());
            p_30634_.m_146926_(this.m_146909_());
            p_30634_.m_20329_((Entity)this);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() && this.m_20160_() && this.m_6254_();
    }

    public void m_7023_(Vec3 motion) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.m_5807_() && this.m_6254_()) {
                LivingEntity livingentity = (LivingEntity)this.m_6688_();
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20883_ = this.m_146908_();
                this.f_20885_ = this.m_146908_();
                this.f_20887_ = this.m_6113_() * 0.1f;
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.f_19861_) {
                    double d0 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + this.m_182332_();
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.setIsJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.6f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.6f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                this.f_20887_ = this.m_6113_() * 0.2f;
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)f, motion.f_82480_, (double)f1));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.f_19861_) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setIsJumping(false);
                }
                this.m_21043_((LivingEntity)this, false);
                this.m_146872_();
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(motion);
            }
        }
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SADDLED);
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean bool) {
        this.isJumping = bool;
    }

    public Vec3 m_7688_(LivingEntity entity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(entity);
        }
        int[][] aint = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockpos = this.m_142538_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Pose pose : entity.m_7431_()) {
            AABB aabb = entity.m_21270_(pose);
            for (int[] aint1 : aint) {
                Vec3 vec3;
                blockpos$mutableblockpos.m_122178_(blockpos.m_123341_() + aint1[0], blockpos.m_123342_(), blockpos.m_123343_() + aint1[1]);
                double d0 = this.f_19853_.m_45573_((BlockPos)blockpos$mutableblockpos);
                if (!DismountHelper.m_38439_((double)d0) || !DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)entity, (AABB)aabb.m_82383_(vec3 = Vec3.m_82514_((Vec3i)blockpos$mutableblockpos, (double)d0)))) continue;
                entity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(entity);
    }

    public void m_7888_(int amount) {
        if (this.m_6254_()) {
            if (amount < 0) {
                amount = 0;
            }
            this.playerJumpPendingScale = amount >= 90 ? 1.0f : 0.4f + 0.4f * (float)amount / 90.0f;
        }
    }

    public boolean m_7132_() {
        return this.m_6254_();
    }

    public void m_7199_(int p_21695_) {
    }

    public void m_8012_() {
    }

    public int getMaxTemper() {
        return 50;
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int val) {
        this.temper = val;
    }

    public int modifyTemper(int val) {
        int i = Mth.m_14045_((int)(this.getTemper() + val), (int)0, (int)this.getMaxTemper());
        this.setTemper(i);
        return i;
    }

    public void makeMad() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return (List)ExoticBirdsCommonConfig.blacklistedDimensionsOstrich.get();
    }

    @Override
    public List<ItemStack> getTemptingItems() {
        return Arrays.asList(FOOD_ITEMS.m_43908_());
    }

    @Override
    public List<ItemStack> getTamingItems() {
        return Arrays.asList(new ItemStack((ItemLike)Items.f_42450_));
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.m_6084_() && this.m_6254_() && !this.m_20160_();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        if (!world.f_46443_) {
            this.setSaddle(false);
            return Arrays.asList(new ItemStack((ItemLike)Items.f_42450_));
        }
        return Collections.emptyList();
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        if (!(spawnData instanceof AbstractBirdEntity.BirdGroupData)) {
            spawnData = new AbstractBirdEntity.BirdGroupData((AbstractBirdEntity)this, 0.5f);
        }
        return super.m_6518_(level, difficulty, reason, (SpawnGroupData)spawnData, tag);
    }
}

