/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.WoodpeckerEntity;

@OnlyIn(value=Dist.CLIENT)
public class WoodpeckerModel<T extends WoodpeckerEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation WOODPECKER_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "woodpecker"), "main");
    private final ModelPart leg1;
    private final ModelPart body;
    private final ModelPart leg2;
    private final ModelPart beak;
    private final ModelPart quiff;
    private final ModelPart head;
    private final ModelPart train;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart neck;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public WoodpeckerModel(ModelPart part) {
        this.leg1 = part.m_171324_("leg1");
        this.body = part.m_171324_("body");
        this.leg2 = part.m_171324_("leg2");
        this.beak = part.m_171324_("beak");
        this.quiff = part.m_171324_("quiff");
        this.head = part.m_171324_("head");
        this.train = part.m_171324_("train");
        this.leftLeg = part.m_171324_("leftLeg");
        this.rightLeg = part.m_171324_("rightLeg");
        this.neck = part.m_171324_("neck");
        this.rightWing = part.m_171324_("rightWing");
        this.leftWing = part.m_171324_("leftWing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171423_((float)1.5f, (float)20.0f, (float)-1.5f, (float)-0.122173f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, -1.0f, -2.0f, 5.0f, 4.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)-2.0f, (float)-0.3717861f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171423_((float)-1.5f, (float)20.0f, (float)-1.5f, (float)-0.122173f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(12, 12).m_171481_(-0.5f, -3.3f, -5.5f, 1.0f, 1.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)17.5f, (float)-5.0f, (float)0.2094395f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("quiff", CubeListBuilder.m_171558_().m_171514_(18, -5).m_171481_(0.0f, -7.0f, -0.3f, 0.0f, 4.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)17.5f, (float)-5.0f, (float)0.2094395f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(31, 10).m_171481_(-2.0f, -5.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)17.5f, (float)-5.0f, (float)0.2094395f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("train", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171481_(-2.0f, 1.0f, 4.0f, 4.0f, 2.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)-2.0f, (float)-0.1858931f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.5f, (float)20.5f, (float)-1.5f, (float)-0.0523599f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(4, 12).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-1.5f, (float)20.5f, (float)-1.5f, (float)-0.0523599f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-1.5f, -1.0f, -5.0f, 3.0f, 2.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)18.5f, (float)-3.0f, (float)-0.9712912f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(20, 12).m_171481_(-1.5f, 0.0f, -2.0f, 1.0f, 4.0f, 9.0f), PartPose.m_171423_((float)-2.0f, (float)16.0f, (float)-2.0f, (float)-0.148353f, (float)0.148353f, (float)0.148353f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(0.5f, 0.0f, -2.0f, 1.0f, 4.0f, 9.0f), PartPose.m_171423_((float)2.0f, (float)16.0f, (float)-2.0f, (float)-0.148353f, (float)-0.148353f, (float)-0.148353f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.beak, (Object)this.quiff, (Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.leg1, (Object)this.body, (Object)this.leg2, (Object)this.train, (Object)this.leftLeg, (Object)this.rightLeg, (Object)this.neck, (Object)this.rightWing, (Object)this.leftWing);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((WoodpeckerEntity)((Object)entityIn)).getIsHanging()) {
            this.leg1.m_104227_(1.5f, 19.0f, -5.6f);
            this.leg2.m_104227_(-1.5f, 19.0f, -5.6f);
            this.body.m_104227_(0.0f, 17.0f, -2.5f);
            this.beak.m_104227_(0.0f, 14.5f, -4.0f);
            this.quiff.m_104227_(0.0f, 14.5f, -4.0f);
            this.head.m_104227_(0.0f, 14.5f, -4.0f);
            this.train.m_104227_(0.0f, 17.0f, -2.0f);
            this.leftLeg.m_104227_(1.5f, 18.8f, -6.0f);
            this.rightLeg.m_104227_(-1.5f, 18.8f, -6.0f);
            this.neck.m_104227_(0.0f, 15.5f, -4.0f);
            this.rightWing.m_104227_(-2.0f, 17.0f, -1.0f);
            this.leftWing.m_104227_(2.0f, 17.0f, -1.0f);
            this.leg1.f_104203_ = -1.692969f;
            this.leg2.f_104203_ = -1.692969f;
            this.body.f_104203_ = -1.788601f;
            this.train.f_104203_ = -1.745329f;
            this.leftLeg.f_104203_ = -2.094395f;
            this.rightLeg.f_104203_ = -2.094395f;
            this.rightWing.f_104203_ = -1.719149f;
            this.rightWing.f_104204_ = 0.148353f;
            this.rightWing.f_104205_ = -0.148353f;
            this.leftWing.f_104203_ = -1.719149f;
            this.leftWing.f_104204_ = -0.148353f;
            this.leftWing.f_104205_ = 0.148353f;
        } else {
            this.leg1.m_104227_(1.5f, 20.0f, -1.5f);
            this.leg2.m_104227_(-1.5f, 20.0f, -1.5f);
            this.body.m_104227_(0.0f, 17.0f, -2.0f);
            this.beak.m_104227_(0.0f, 17.5f, -5.0f);
            this.quiff.m_104227_(0.0f, 17.5f, -5.0f);
            this.head.m_104227_(0.0f, 17.5f, -5.0f);
            this.train.m_104227_(0.0f, 17.0f, -2.0f);
            this.leftLeg.m_104227_(1.5f, 20.5f, -1.5f);
            this.rightLeg.m_104227_(-1.5f, 20.5f, -1.5f);
            this.neck.m_104227_(0.0f, 18.5f, -3.0f);
            this.rightWing.m_104227_(-2.0f, 16.0f, -2.0f);
            this.leftWing.m_104227_(2.0f, 16.0f, -2.0f);
            this.leg1.f_104203_ = -0.122173f;
            this.leg2.f_104203_ = -0.122173f;
            this.body.f_104203_ = -0.3717861f;
            this.train.f_104203_ = -0.1858931f;
            this.leftLeg.f_104203_ = -0.0523599f;
            this.rightLeg.f_104203_ = -0.0523599f;
            this.rightWing.f_104203_ = -0.148353f;
            this.rightWing.f_104204_ = 0.148353f;
            this.rightWing.f_104205_ = 0.148353f;
            this.leftWing.f_104203_ = -0.148353f;
            this.leftWing.f_104204_ = -0.148353f;
            this.leftWing.f_104205_ = -0.148353f;
            this.rightWing.f_104205_ = ageInTicks;
            this.leftWing.f_104205_ = -ageInTicks;
        }
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.45f, 0.45f, 0.45f);
            stack.m_85837_(0.0, (double)1.2f, (double)-0.1f);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            stack.m_85836_();
            stack.m_85841_(0.7f, 0.7f, 0.7f);
            stack.m_85837_(0.0, 0.0, (double)-0.2f);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        }
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        if (((WoodpeckerEntity)((Object)entityIn)).getIsHanging()) {
            this.neck.f_104203_ = ((WoodpeckerEntity)((Object)entityIn)).getPeckAngle(partialTick, -0.2f);
            this.beak.f_104203_ = this.quiff.f_104203_ = this.neck.f_104203_ + 1.4531671f;
            this.head.f_104203_ = this.quiff.f_104203_;
        } else {
            this.neck.f_104203_ = -0.9712912f;
            this.quiff.f_104203_ = 0.2094395f;
            this.beak.f_104203_ = 0.2094395f;
            this.head.f_104203_ = 0.2094395f;
        }
    }
}

