/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.PenguinEntity;

@OnlyIn(value=Dist.CLIENT)
public class PenguinModel<T extends PenguinEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation PENGUIN_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "penguin"), "main");
    private final ModelPart lowerBody;
    private final ModelPart breast;
    private final ModelPart neckpiece;
    private final ModelPart neck;
    private final ModelPart lowerBeak;
    private final ModelPart beakTip;
    private final ModelPart head;
    private final ModelPart rightThigh;
    private final ModelPart leftThigh;
    private final ModelPart leftLeg;
    private final ModelPart leftFoot;
    private final ModelPart rightLeg;
    private final ModelPart rightFoot;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart upperBeak;

    public PenguinModel(ModelPart part) {
        this.lowerBody = part.m_171324_("lowerBody");
        this.breast = part.m_171324_("breast");
        this.neckpiece = part.m_171324_("neckpiece");
        this.neck = part.m_171324_("neck");
        this.lowerBeak = part.m_171324_("lowerBeak");
        this.beakTip = part.m_171324_("beakTip");
        this.head = part.m_171324_("head");
        this.rightThigh = part.m_171324_("rightThigh");
        this.leftThigh = part.m_171324_("leftThigh");
        this.leftLeg = part.m_171324_("leftLeg");
        this.leftFoot = part.m_171324_("leftFoot");
        this.rightLeg = part.m_171324_("rightLeg");
        this.rightFoot = part.m_171324_("rightFoot");
        this.rightWing = part.m_171324_("rightWing");
        this.leftWing = part.m_171324_("leftWing");
        this.upperBeak = part.m_171324_("upperBeak");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("lowerBody", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-3.5f, 0.0f, -3.2f, 7.0f, 6.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)0.0f, (float)0.0174533f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("breast", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, 0.0f, -3.5f, 8.0f, 8.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)0.0f, (float)-0.0349066f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("neckpiece", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(-3.5f, -0.8f, -3.1f, 7.0f, 2.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)0.0f, (float)0.0698132f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171481_(-2.0f, -3.4f, -4.3f, 4.0f, 2.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)11.7f, (float)0.3f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("lowerBeak", CubeListBuilder.m_171558_().m_171514_(0, 53).m_171481_(-1.0f, -1.5f, -4.6f, 2.0f, 1.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)-2.0f, (float)-0.0918105f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("beakTip", CubeListBuilder.m_171558_().m_171514_(0, 58).m_171481_(-1.0f, 2.6f, -4.6f, 2.0f, 1.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)-2.0f, (float)-0.8901179f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-2.5f, -3.2f, -2.3f, 5.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)-2.0f, (float)-0.0219973f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightThigh", CubeListBuilder.m_171558_().m_171514_(42, 12).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f), PartPose.m_171423_((float)-1.8f, (float)21.6f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftThigh", CubeListBuilder.m_171558_().m_171514_(30, 12).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f), PartPose.m_171423_((float)1.8f, (float)21.6f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(30, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)1.8f, (float)22.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(30, 20).m_171481_(-1.8f, 2.0f, -3.0f, 3.0f, 0.0f, 4.0f), PartPose.m_171423_((float)1.8f, (float)22.0f, (float)0.0f, (float)0.0f, (float)-0.0523599f, (float)0.0f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(38, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-1.8f, (float)22.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(30, 24).m_171481_(-1.2f, 2.0f, -3.0f, 3.0f, 0.0f, 4.0f), PartPose.m_171423_((float)-1.8f, (float)22.0f, (float)0.0f, (float)0.0f, (float)0.0523599f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-1.0f, -1.0f, -2.0f, 1.0f, 8.0f, 4.0f), PartPose.m_171423_((float)-3.7f, (float)12.0f, (float)0.5f, (float)-0.122173f, (float)0.0f, (float)-0.0349066f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171481_(0.0f, -1.0f, -2.0f, 1.0f, 8.0f, 4.0f), PartPose.m_171423_((float)3.7f, (float)12.0f, (float)0.5f, (float)-0.122173f, (float)0.0f, (float)0.0349066f));
        partdefinition.m_171599_("upperBeak", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171481_(-1.5f, -2.5f, -4.9f, 3.0f, 1.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)-2.0f, (float)0.1047198f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.neckpiece, (Object)this.neck, (Object)this.lowerBeak, (Object)this.beakTip, (Object)this.head, (Object)this.upperBeak);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.lowerBody, (Object)this.breast, (Object)this.rightThigh, (Object)this.leftThigh, (Object)this.leftLeg, (Object)this.leftFoot, (Object)this.rightLeg, (Object)this.rightFoot, (Object)this.rightWing, (Object)this.leftWing);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.f_102610_) {
            this.breast.m_104227_(0.0f, 9.0f, 0.0f);
            this.lowerBody.m_104227_(0.0f, 16.0f, 0.0f);
            this.leftWing.m_104227_(3.7f, 12.0f, 0.5f);
            this.rightWing.m_104227_(-3.7f, 12.0f, 0.5f);
            this.leftWing.f_104205_ = ageInTicks + 0.0349066f;
            this.rightWing.f_104205_ = -this.leftWing.f_104205_;
        } else {
            this.breast.m_104227_(0.0f, 14.0f, 0.0f);
            this.lowerBody.m_104227_(0.0f, 8.5f, 0.0f);
            this.leftWing.m_104227_(3.4f, 12.0f, 0.5f);
            this.rightWing.m_104227_(-3.4f, 12.0f, 0.5f);
            this.leftWing.f_104205_ = ageInTicks + 0.0549066f;
            this.rightWing.f_104205_ = -this.leftWing.f_104205_;
        }
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.upperBeak.f_104203_ = this.head.f_104203_ + 0.0219973f + 0.1047198f;
        this.lowerBeak.f_104203_ = this.head.f_104203_ + 0.0219973f - 0.0918105f;
        this.beakTip.f_104203_ = this.head.f_104203_ + 0.0219973f - 0.8901179f;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.5f, 0.5f, 0.5f);
            stack.m_85837_(0.0, 1.5, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
        }
    }
}

