/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.KiwiEntity;

@OnlyIn(value=Dist.CLIENT)
public class KiwiModel<T extends KiwiEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation KIWI_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "kiwi"), "main");
    private final ModelPart body;
    private final ModelPart tash;
    private final ModelPart head;
    private final ModelPart rightAnkle;
    private final ModelPart rightThigh;
    private final ModelPart rightFoot;
    private final ModelPart leftAnkle;
    private final ModelPart leftThigh;
    private final ModelPart leftFoot;
    private final ModelPart beak;

    public KiwiModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.tash = part.m_171324_("tash");
        this.head = part.m_171324_("head");
        this.rightAnkle = part.m_171324_("rightAnkle");
        this.rightThigh = part.m_171324_("rightThigh");
        this.rightFoot = part.m_171324_("rightFoot");
        this.leftAnkle = part.m_171324_("leftAnkle");
        this.leftThigh = part.m_171324_("leftThigh");
        this.leftFoot = part.m_171324_("leftFoot");
        this.beak = part.m_171324_("beak");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)18.6f, (float)-2.0f, (float)0.1745329f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tash", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -2.2f, -2.7f, 2.0f, 1.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)16.6f, (float)-1.0f, (float)0.6108652f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171481_(-1.5f, -2.5f, -3.0f, 3.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)16.6f, (float)-1.0f, (float)0.3141593f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightAnkle", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171481_(-0.5f, 3.0f, -0.2f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-2.0f, (float)18.0f, (float)2.0f, (float)-0.0698132f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightThigh", CubeListBuilder.m_171558_().m_171514_(10, 24).m_171481_(-1.0f, 0.0f, -1.2f, 2.0f, 3.0f, 3.0f), PartPose.m_171423_((float)-2.0f, (float)18.0f, (float)2.0f, (float)-0.122173f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(22, 24).m_171481_(-1.0f, 6.0f, -1.2f, 2.0f, 0.0f, 2.0f), PartPose.m_171423_((float)-2.0f, (float)18.0f, (float)2.0f, (float)-0.0698132f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftAnkle", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171481_(-0.5f, 3.0f, -0.2f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)2.0f, (float)18.0f, (float)2.0f, (float)-0.0698132f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftThigh", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171481_(-1.0f, 0.0f, -1.2f, 2.0f, 3.0f, 3.0f), PartPose.m_171423_((float)2.0f, (float)18.0f, (float)2.0f, (float)-0.122173f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(22, 6).m_171481_(-1.0f, 6.0f, -1.2f, 2.0f, 0.0f, 2.0f), PartPose.m_171423_((float)2.0f, (float)18.0f, (float)2.0f, (float)-0.0698132f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(-0.5f, -1.0f, -7.6f, 1.0f, 1.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)16.6f, (float)-1.0f, (float)0.4363323f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head, (Object)this.beak, (Object)this.tash);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightAnkle, (Object)this.rightThigh, (Object)this.rightFoot, (Object)this.leftAnkle, (Object)this.leftThigh, (Object)this.leftFoot);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = -(headPitch / 57.295776f) + 0.3141593f;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.beak.f_104203_ = -(headPitch / 57.295776f) + 0.4363323f;
        this.beak.f_104204_ = netHeadYaw / 57.295776f;
        this.tash.f_104203_ = -(headPitch / 57.295776f) + 0.6108652f;
        this.tash.f_104204_ = netHeadYaw / 57.295776f;
        this.rightAnkle.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount - 0.0698132f;
        this.rightThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount - 0.122173f;
        this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount - 0.0698132f;
        this.leftAnkle.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount - 0.0698132f;
        this.leftThigh.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount - 0.122173f;
        this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount - 0.0698132f;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.7f, 0.7f, 0.7f);
            stack.m_85837_(0.0, 0.6, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
        }
    }
}

