/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.GouldianFinchEntity;

@OnlyIn(value=Dist.CLIENT)
public class GouldianFinchModel<T extends GouldianFinchEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation GOULDIANFINCH_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "gouldianfinch"), "main");
    private final ModelPart body;
    private final ModelPart beak;
    private final ModelPart head;
    private final ModelPart breast;
    private final ModelPart tail;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart rightLeg;
    private final ModelPart rightFoot;
    private final ModelPart leftLeg;
    private final ModelPart leftFoot;

    public GouldianFinchModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.beak = part.m_171324_("beak");
        this.head = part.m_171324_("head");
        this.breast = part.m_171324_("breast");
        this.tail = part.m_171324_("tail");
        this.rightWing = part.m_171324_("rightWing");
        this.leftWing = part.m_171324_("leftWing");
        this.rightLeg = part.m_171324_("rightLeg");
        this.rightFoot = part.m_171324_("rightFoot");
        this.leftLeg = part.m_171324_("leftLeg");
        this.leftFoot = part.m_171324_("leftFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171481_(-1.5f, 2.0f, -2.0f, 3.0f, 4.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)0.0f, (float)0.5585054f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(-1.0f, -1.0f, -2.3f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-1.5f, -2.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)0.0f, (float)-0.0872665f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("breast", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)17.0f, (float)0.0f, (float)0.4014257f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 5.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)1.0f, (float)1.047198f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-1.0f, -1.0f, -2.0f, 1.0f, 5.0f, 3.0f), PartPose.m_171423_((float)-1.7f, (float)18.0f, (float)1.0f, (float)0.6632251f, (float)0.0872665f, (float)-0.0349066f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(0.0f, -1.0f, -2.0f, 1.0f, 5.0f, 3.0f), PartPose.m_171423_((float)1.7f, (float)18.0f, (float)1.0f, (float)0.6632251f, (float)-0.0872665f, (float)0.0349066f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(20, 8).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-0.8f, (float)21.0f, (float)1.0f, (float)-0.136591f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171481_(-1.2f, 3.0f, -1.5f, 2.0f, 0.0f, 2.0f), PartPose.m_171423_((float)-0.8f, (float)21.0f, (float)1.0f, (float)-0.136591f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(16, 8).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.8f, (float)21.0f, (float)1.0f, (float)-0.136591f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171481_(-0.8f, 3.0f, -1.5f, 2.0f, 0.0f, 2.0f), PartPose.m_171423_((float)0.8f, (float)21.0f, (float)1.0f, (float)-0.136591f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.beak, (Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.breast, (Object)this.tail, (Object)this.rightWing, (Object)this.leftWing, (Object)this.rightLeg, (Object)this.rightFoot, (Object)this.leftLeg, (Object)this.leftFoot);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = -(headPitch / 57.295776f) - 0.0872665f;
        this.beak.f_104204_ = this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.beak.f_104203_ = this.head.f_104203_ + 0.0872665f - 0.7853982f;
        if (entityIn.m_20096_()) {
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount - 0.136591f;
            this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount - 0.136591f;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount - 0.136591f;
            this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount - 0.136591f;
        } else {
            this.rightLeg.f_104203_ = -0.136591f;
            this.rightFoot.f_104203_ = -0.136591f;
            this.leftLeg.f_104203_ = -0.136591f;
            this.leftFoot.f_104203_ = -0.136591f;
        }
        this.rightWing.f_104205_ = ageInTicks;
        this.leftWing.f_104205_ = -ageInTicks;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.5f, 0.5f, 0.5f);
            stack.m_85837_(0.0, 1.5, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            stack.m_85836_();
            stack.m_85841_(0.8f, 0.8f, 0.8f);
            stack.m_85837_(0.0, (double)0.38f, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        }
    }
}

