/*
 * Decompiled with CFR 0.152.
 */
package com.pam.pamhc2trees;

import com.pam.pamhc2trees.Pamhc2trees;
import com.pam.pamhc2trees.config.Config;
import com.pam.pamhc2trees.events.EventSetup;
import com.pam.pamhc2trees.init.BlockRegistry;
import com.pam.pamhc2trees.init.ColdFruitTreeWorldGenRegistry;
import com.pam.pamhc2trees.init.CompostRegistry;
import com.pam.pamhc2trees.init.ItemRegistry;
import com.pam.pamhc2trees.init.ModRenderers;
import com.pam.pamhc2trees.init.TemperateFruitTreeWorldGenRegistry;
import com.pam.pamhc2trees.init.WarmFruitTreeWorldGenRegistry;
import com.pam.pamhc2trees.init.WorldGenRegistry;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

public class SideProxy {
    SideProxy() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.CONFIG, "pamhc2trees.toml");
        eventBus.addListener(SideProxy::commonSetup);
        eventBus.addListener(SideProxy::enqueueIMC);
        eventBus.addListener(SideProxy::processIMC);
        BlockRegistry.registerAll(eventBus);
        ItemRegistry.registerAll(eventBus);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Feature.class, WorldGenRegistry::registerAll);
        Config.loadConfig(Config.CONFIG, FMLPaths.CONFIGDIR.get().resolve("pamhc2trees.toml").toString());
        MinecraftForge.EVENT_BUS.addListener(SideProxy::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::onBiomeLoad);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        Pamhc2trees.LOGGER.debug("common setup");
        EventSetup.setupEvents();
        event.enqueueWork(() -> CompostRegistry.register());
    }

    private static void enqueueIMC(InterModEnqueueEvent event) {
    }

    private static void processIMC(InterModProcessEvent event) {
    }

    private static void serverStarting(ServerStartingEvent event) {
    }

    private static void onBiomeLoad(BiomeLoadingEvent event) {
        TemperateFruitTreeWorldGenRegistry.addToBiome(event);
        WarmFruitTreeWorldGenRegistry.addToBiomes(event);
        ColdFruitTreeWorldGenRegistry.addToBiomes(event);
    }

    static class Server
    extends SideProxy {
        Server() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(Server::serverSetup);
        }

        private static void serverSetup(FMLDedicatedServerSetupEvent event) {
        }
    }

    static class Client
    extends SideProxy {
        Client() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(Client::clientSetup);
        }

        private static void clientSetup(FMLClientSetupEvent event) {
            ModRenderers.registerBlocks();
        }
    }
}

