/*
 * Decompiled with CFR 0.152.
 */
package mezz.modnametooltip;

import java.util.List;
import javax.annotation.Nullable;
import mezz.modnametooltip.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.StringUtils;

public class TooltipEventHandler {
    private final Config config;

    public TooltipEventHandler(Config config) {
        this.config = config;
    }

    public void onToolTip(ItemTooltipEvent event) {
        List toolTip;
        ItemStack itemStack;
        String modName;
        String modNameFormat = this.config.getModNameFormat();
        if (!modNameFormat.isEmpty() && (modName = TooltipEventHandler.getModName(itemStack = event.getItemStack())) != null && !TooltipEventHandler.isModNameAlreadyPresent(toolTip = event.getToolTip(), modName)) {
            toolTip.add(new TextComponent(modNameFormat + modName));
        }
    }

    @Nullable
    private static String getModName(ItemStack itemStack) {
        Item item;
        String modId;
        if (!itemStack.m_41619_() && (modId = (item = itemStack.m_41720_()).getCreatorModId(itemStack)) != null) {
            return ModList.get().getModContainerById(modId).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
        }
        return null;
    }

    private static boolean isModNameAlreadyPresent(List<Component> tooltip, String modName) {
        if (tooltip.size() > 1) {
            Component line = tooltip.get(tooltip.size() - 1);
            String lineString = line.getString();
            String withoutFormatting = ChatFormatting.m_126649_((String)lineString);
            return modName.equals(withoutFormatting);
        }
        return false;
    }
}

