/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.coderbot.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.coderbot.iris.mixin.GameRendererAccessor;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.state.BlockState;

public class HandRenderer {
    public static final HandRenderer INSTANCE = new HandRenderer();
    private boolean ACTIVE;
    private boolean renderingSolid;
    private final FullyBufferedMultiBufferSource bufferSource = new FullyBufferedMultiBufferSource();
    public static final float DEPTH = 0.125f;

    private void setupGlState(GameRenderer gameRenderer, Camera camera, PoseStack poseStack, float tickDelta) {
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f scaleMatrix = Matrix4f.m_27632_((float)1.0f, (float)1.0f, (float)0.125f);
        scaleMatrix.m_27644_(gameRenderer.m_172716_(((GameRendererAccessor)gameRenderer).invokeGetFov(camera, tickDelta, false)));
        gameRenderer.m_109111_(scaleMatrix);
        pose.m_85861_().m_27624_();
        pose.m_85864_().m_8180_();
        ((GameRendererAccessor)gameRenderer).invokeBobHurt(poseStack, tickDelta);
        if (Minecraft.m_91087_().f_91066_.f_92080_) {
            ((GameRendererAccessor)gameRenderer).invokeBobView(poseStack, tickDelta);
        }
    }

    private boolean canRender(Camera camera, GameRenderer gameRenderer) {
        return ((GameRendererAccessor)gameRenderer).getRenderHand() && !camera.m_90594_() && camera.m_90592_() instanceof Player && !((GameRendererAccessor)gameRenderer).getPanoramicMode() && !Minecraft.m_91087_().f_91066_.f_92062_ && (!(camera.m_90592_() instanceof LivingEntity) || !((LivingEntity)camera.m_90592_()).m_5803_()) && Minecraft.m_91087_().f_91072_.m_105295_() != GameType.SPECTATOR;
    }

    public boolean isHandTranslucent(InteractionHand hand) {
        Item item = Minecraft.m_91087_().f_91074_.m_6844_(hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND).m_41720_();
        if (item instanceof BlockItem) {
            return ItemBlockRenderTypes.m_109282_((BlockState)((BlockItem)item).m_40614_().m_49966_()) == RenderType.m_110466_();
        }
        return false;
    }

    public boolean isAnyHandTranslucent() {
        return this.isHandTranslucent(InteractionHand.MAIN_HAND) || this.isHandTranslucent(InteractionHand.OFF_HAND);
    }

    public void renderSolid(PoseStack poseStack, float tickDelta, Camera camera, GameRenderer gameRenderer, WorldRenderingPipeline pipeline) {
        if (!this.canRender(camera, gameRenderer) || !IrisApi.getInstance().isShaderPackInUse()) {
            return;
        }
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_SOLID);
        poseStack.m_85836_();
        Minecraft.m_91087_().m_91307_().m_6180_("iris_hand");
        this.setupGlState(gameRenderer, camera, poseStack, tickDelta);
        this.renderingSolid = true;
        Minecraft.m_91087_().m_91292_().m_109314_(tickDelta, poseStack, (MultiBufferSource.BufferSource)this.bufferSource, Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().m_91290_().m_114394_(camera.m_90592_(), tickDelta));
        Minecraft.m_91087_().m_91307_().m_7238_();
        gameRenderer.m_109111_(CapturedRenderingState.INSTANCE.getGbufferProjection());
        poseStack.m_85849_();
        this.bufferSource.m_109911_();
        this.renderingSolid = false;
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public void renderTranslucent(PoseStack poseStack, float tickDelta, Camera camera, GameRenderer gameRenderer, WorldRenderingPipeline pipeline) {
        if (!(this.canRender(camera, gameRenderer) && this.isAnyHandTranslucent() && IrisApi.getInstance().isShaderPackInUse())) {
            return;
        }
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_TRANSLUCENT);
        poseStack.m_85836_();
        Minecraft.m_91087_().m_91307_().m_6180_("iris_hand_translucent");
        this.setupGlState(gameRenderer, camera, poseStack, tickDelta);
        Minecraft.m_91087_().m_91292_().m_109314_(tickDelta, poseStack, (MultiBufferSource.BufferSource)this.bufferSource, Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().m_91290_().m_114394_(camera.m_90592_(), tickDelta));
        poseStack.m_85849_();
        Minecraft.m_91087_().m_91307_().m_7238_();
        gameRenderer.m_109111_(CapturedRenderingState.INSTANCE.getGbufferProjection());
        this.bufferSource.m_109911_();
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public boolean isActive() {
        return this.ACTIVE;
    }

    public boolean isRenderingSolid() {
        return this.renderingSolid;
    }

    public FullyBufferedMultiBufferSource getBufferSource() {
        return this.bufferSource;
    }
}

