/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.client.settings.ClientChopSettings;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.network.ConfirmedSetting;
import ht.treechop.common.network.PacketHandler;
import ht.treechop.common.network.ServerConfirmSettingsPacket;
import ht.treechop.common.network.ServerPermissionsPacket;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.server.Server;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ClientRequestSettingsPacket {
    private final List<Setting> settings;
    private final Event event;

    public ClientRequestSettingsPacket(List<Setting> settings, Event event) {
        this.settings = settings;
        this.event = event;
    }

    public ClientRequestSettingsPacket(SettingsField field, Object value) {
        this(Collections.singletonList(new Setting(field, value)), Event.REQUEST);
    }

    public ClientRequestSettingsPacket(ClientChopSettings chopSettings) {
        this(chopSettings.getAll(), Event.FIRST_TIME_SYNC);
    }

    public static void encode(ClientRequestSettingsPacket message, FriendlyByteBuf buffer) {
        message.event.encode(buffer);
        buffer.writeInt(message.settings.size());
        message.settings.forEach(setting -> setting.encode(buffer));
    }

    public static ClientRequestSettingsPacket decode(FriendlyByteBuf buffer) {
        Event event = Event.decode(buffer);
        int numSettings = buffer.readInt();
        List<Setting> settings = IntStream.range(0, numSettings).mapToObj($ -> Setting.decode(buffer)).collect(Collectors.toList());
        return new ClientRequestSettingsPacket(settings, event);
    }

    public static void handle(ClientRequestSettingsPacket message, Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide().isServer()) {
            context.get().enqueueWork(() -> ClientRequestSettingsPacket.processSettingsRequest(message, Objects.requireNonNull(((NetworkEvent.Context)context.get()).getSender())));
            context.get().setPacketHandled(true);
        }
    }

    private static <T> void processSettingsRequest(ClientRequestSettingsPacket message, ServerPlayer player) {
        ChopSettingsCapability.forPlayer((Player)player).ifPresent(capability -> ClientRequestSettingsPacket.processSettingsRequest(capability, message, player));
    }

    private static void processSettingsRequest(ChopSettingsCapability capability, ClientRequestSettingsPacket message, ServerPlayer player) {
        List<Setting> settings = message.event == Event.FIRST_TIME_SYNC && capability.isSynced() ? capability.getAll() : message.settings;
        List<ConfirmedSetting> confirmedSettings = settings.stream().map(setting -> ClientRequestSettingsPacket.processSingleSettingRequest(setting, player, capability, message.event)).collect(Collectors.toList());
        PacketHandler.sendTo(player, new ServerConfirmSettingsPacket(confirmedSettings));
        if (message.event == Event.FIRST_TIME_SYNC) {
            if (!capability.isSynced()) {
                capability.setSynced();
            }
            PacketHandler.sendTo(player, new ServerPermissionsPacket(Server.getPermissions()));
        }
    }

    private static ConfirmedSetting processSingleSettingRequest(Setting setting, ServerPlayer player, ChopSettings chopSettings, Event requestEvent) {
        ConfirmedSetting.Event confirmEvent;
        if (ClientRequestSettingsPacket.playerHasPermission((Player)player, setting)) {
            chopSettings.set(setting);
            confirmEvent = ConfirmedSetting.Event.ACCEPT;
        } else {
            Setting defaultSetting = ClientRequestSettingsPacket.getDefaultSetting(player, setting);
            chopSettings.set(defaultSetting);
            confirmEvent = ConfirmedSetting.Event.DENY;
        }
        if (requestEvent == Event.FIRST_TIME_SYNC) {
            confirmEvent = ConfirmedSetting.Event.SILENT;
        }
        SettingsField field = setting.getField();
        return new ConfirmedSetting(new Setting(field, chopSettings.get(field)), confirmEvent);
    }

    private static Setting getDefaultSetting(ServerPlayer player, Setting setting) {
        return Server.getDefaultPlayerSettings().getSetting(setting.getField());
    }

    private static boolean playerHasPermission(Player player, Setting setting) {
        return Server.getPermissions().isPermitted(setting);
    }

    private static enum Event {
        FIRST_TIME_SYNC,
        REQUEST;

        private static final Event[] values;

        public static Event decode(FriendlyByteBuf buffer) {
            int ordinal = buffer.readByte() % values.length;
            return values[ordinal];
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.writeByte(this.ordinal());
        }

        static {
            values = Event.values();
        }
    }
}

