/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.sound;

import com.mojang.blaze3d.audio.Channel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Options;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.LoopingAudioStream;
import net.minecraft.client.sounds.SoundManager;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import team.creative.ambientsounds.AmbientSound;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.reflection.ReflectionHelper;

public class AmbientSoundEngine {
    private static Field sourceField;
    private static Field streamField;
    private static Field bufferedInputStreamField;
    public SoundManager manager;
    public Options options;
    private List<AmbientSound.SoundStream> sounds = new ArrayList<AmbientSound.SoundStream>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int playingCount() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            return this.sounds.size();
        }
    }

    public AmbientSoundEngine(SoundManager manager, Options options) {
        this.options = options;
        this.manager = manager;
        CreativeCore.loader().registerListener(this::play);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            Double mute = null;
            try {
                for (AmbientSound.SoundStream sound : this.sounds) {
                    double soundMute = sound.mute();
                    if (!(soundMute > 0.0) || mute != null && !(mute < soundMute)) continue;
                    mute = soundMute;
                }
                Iterator<AmbientSound.SoundStream> iterator = this.sounds.iterator();
                while (iterator.hasNext()) {
                    boolean playing;
                    AmbientSound.SoundStream sound;
                    sound = iterator.next();
                    if (!this.manager.m_120403_((SoundInstance)sound)) {
                        if (!sound.hasPlayedOnce()) continue;
                        playing = false;
                    } else {
                        playing = true;
                    }
                    if (sound.hasPlayedOnce() && !playing) {
                        sound.onFinished();
                        this.manager.m_120399_((SoundInstance)sound);
                        iterator.remove();
                        continue;
                    }
                    if (!sound.hasPlayedOnce() && playing) {
                        sound.setPlayedOnce();
                    }
                    if (mute == null || sound.mute() >= mute) {
                        sound.generatedVoume = (float)sound.volume;
                        continue;
                    }
                    sound.generatedVoume = (float)(sound.volume * (1.0 - mute));
                }
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(AmbientSound.SoundStream sound) {
        this.manager.m_120399_((SoundInstance)sound);
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            this.sounds.remove(sound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(AmbientSound.SoundStream stream) {
        this.manager.m_120367_((SoundInstance)stream);
        stream.onStart();
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            this.sounds.add(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            for (AmbientSound.SoundStream sound : this.sounds) {
                this.stop(sound);
                sound.onFinished();
            }
        }
    }

    public void play(PlayStreamingSourceEvent event) {
        AmbientSound.SoundStream stream;
        SoundInstance soundInstance;
        if (sourceField == null) {
            sourceField = ReflectionHelper.findField(Channel.class, (String)"f_83642_", (String)"source");
            streamField = ReflectionHelper.findField(Channel.class, (String)"f_83645_", (String)"stream");
            bufferedInputStreamField = ReflectionHelper.findField(LoopingAudioStream.class, (String)"f_120161_", (String)"bufferedInputStream");
        }
        if ((soundInstance = event.getSound()) instanceof AmbientSound.SoundStream && (stream = (AmbientSound.SoundStream)soundInstance).loop() && stream.duration != -1) {
            try {
                int source = sourceField.getInt(event.getChannel());
                LoopingAudioStream looping = (LoopingAudioStream)streamField.get(event.getChannel());
                BufferedInputStream in = (BufferedInputStream)bufferedInputStreamField.get(looping);
                int length = in.available() + AL11.alGetSourcei((int)source, (int)4134);
                int offset = (int)(Math.random() * (double)length);
                AL10.alSourcef((int)source, (int)4134, (float)offset);
            }
            catch (IOException | IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

