/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.ISlotColorCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class ItemDisplaySettingsCategory
implements ISettingsCategory,
ISlotColorCategory {
    public static final String NAME = "item_display";
    private static final String SLOT_TAG = "slot";
    private static final String ROTATION_TAG = "rotation";
    private static final String SLOTS_TAG = "slots";
    private static final String ROTATIONS_TAG = "rotations";
    private static final String COLOR_TAG = "color";
    private final Supplier<InventoryHandler> inventoryHandlerSupplier;
    private final Supplier<RenderInfo> renderInfoSupplier;
    private CompoundTag categoryNbt;
    private final Consumer<CompoundTag> saveNbt;
    private final int itemNumberLimit;
    private final Supplier<MemorySettingsCategory> getMemorySettings;
    private DyeColor color = DyeColor.RED;
    private final List<Integer> slotIndexes = new LinkedList<Integer>();
    private Map<Integer, Integer> slotRotations = new HashMap<Integer, Integer>();

    public ItemDisplaySettingsCategory(Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderInfo> renderInfoSupplier, CompoundTag categoryNbt, Consumer<CompoundTag> saveNbt, int itemNumberLimit, Supplier<MemorySettingsCategory> getMemorySettings) {
        this.inventoryHandlerSupplier = inventoryHandlerSupplier;
        this.renderInfoSupplier = renderInfoSupplier;
        this.categoryNbt = categoryNbt;
        this.saveNbt = saveNbt;
        this.itemNumberLimit = itemNumberLimit;
        this.getMemorySettings = getMemorySettings;
        this.deserialize();
    }

    public void unselectSlot(int slotIndex) {
        int orderIndex = this.slotIndexes.indexOf(slotIndex);
        this.slotIndexes.remove(orderIndex);
        this.slotRotations.remove(slotIndex);
        if (this.slotIndexes.isEmpty()) {
            this.categoryNbt.m_128473_(SLOTS_TAG);
            this.categoryNbt.m_128473_(ROTATIONS_TAG);
        }
        this.serializeSlotIndexes();
        this.updateFullRenderInfo();
    }

    private boolean haveRenderedItemsChanged() {
        List<RenderInfo.DisplayItem> previousDisplayItems = this.renderInfoSupplier.get().getItemDisplayRenderInfo().getDisplayItems();
        int i = 0;
        for (int slotIndex : this.slotIndexes) {
            ItemStack newItem = this.getSlotItemCopy(slotIndex).orElse(ItemStack.f_41583_);
            if (newItem.m_41619_()) continue;
            if (previousDisplayItems.size() <= i || ItemStackKey.getHashCode(newItem) != ItemStackKey.getHashCode(previousDisplayItems.get(i).getItem())) {
                return true;
            }
            ++i;
        }
        return i != previousDisplayItems.size();
    }

    private void updateFullRenderInfo() {
        ArrayList<RenderInfo.DisplayItem> displayItems = new ArrayList<RenderInfo.DisplayItem>();
        for (int slotIndex : this.slotIndexes) {
            this.getSlotItemCopy(slotIndex).ifPresent(stackCopy -> displayItems.add(new RenderInfo.DisplayItem((ItemStack)stackCopy, this.slotRotations.getOrDefault(slotIndex, 0))));
        }
        this.renderInfoSupplier.get().refreshItemDisplayRenderInfo(displayItems);
    }

    private Optional<ItemStack> getSlotItemCopy(int slotIndex) {
        ItemStack slotStack = this.inventoryHandlerSupplier.get().getStackInSlot(slotIndex);
        if (slotStack.m_41619_()) {
            return this.getMemorySettings.get().getSlotFilterItem(slotIndex).map(ItemStack::new);
        }
        ItemStack stackCopy = slotStack.m_41777_();
        stackCopy.m_41764_(1);
        return Optional.of(stackCopy);
    }

    public void selectSlot(int slotIndex) {
        if (this.slotIndexes.size() + 1 > this.itemNumberLimit) {
            return;
        }
        this.slotIndexes.add(slotIndex);
        this.serializeSlotIndexes();
        this.updateFullRenderInfo();
    }

    private void serializeSlotIndexes() {
        this.categoryNbt.m_128408_(SLOTS_TAG, this.slotIndexes);
        this.saveNbt.accept(this.categoryNbt);
    }

    public List<Integer> getSlots() {
        return this.slotIndexes;
    }

    public int getRotation(int slotIndex) {
        return this.slotRotations.getOrDefault(slotIndex, 0);
    }

    public void rotate(int slotIndex, boolean clockwise) {
        if (!this.slotIndexes.contains(slotIndex)) {
            return;
        }
        int rotation = this.getRotation(slotIndex);
        rotation = (rotation + (clockwise ? 1 : -1) * 45 + 360) % 360;
        this.slotRotations.put(slotIndex, rotation);
        this.serializeRotations();
        this.updateFullRenderInfo();
    }

    private void serializeRotations() {
        NBTHelper.putMap(this.categoryNbt, ROTATIONS_TAG, this.slotRotations, String::valueOf, IntTag::m_128679_);
        this.saveNbt.accept(this.categoryNbt);
    }

    public void setColor(DyeColor color) {
        this.color = color;
        this.categoryNbt.m_128405_(COLOR_TAG, color.m_41060_());
        this.saveNbt.accept(this.categoryNbt);
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public void reloadFrom(CompoundTag categoryNbt) {
        this.categoryNbt = categoryNbt;
        this.deserialize();
    }

    private void deserialize() {
        this.slotIndexes.clear();
        NBTHelper.getIntArray(this.categoryNbt, SLOTS_TAG).ifPresent(slots -> {
            for (int slot : slots) {
                this.slotIndexes.add(slot);
            }
        });
        this.slotRotations = NBTHelper.getMap(this.categoryNbt, ROTATIONS_TAG, Integer::valueOf, (k, v) -> Optional.of(((IntTag)v).m_7047_())).orElseGet(HashMap::new);
        this.color = NBTHelper.getInt(this.categoryNbt, COLOR_TAG).map(DyeColor::m_41053_).orElse(DyeColor.RED);
        NBTHelper.getInt(this.categoryNbt, SLOT_TAG).ifPresent(e -> {
            this.slotIndexes.add((Integer)e);
            this.categoryNbt.m_128473_(SLOT_TAG);
            this.serializeSlotIndexes();
        });
        NBTHelper.getInt(this.categoryNbt, ROTATION_TAG).ifPresent(r -> {
            if (!this.slotIndexes.isEmpty()) {
                this.slotRotations.put(this.slotIndexes.iterator().next(), (Integer)r);
            }
            this.categoryNbt.m_128473_(ROTATION_TAG);
            this.serializeRotations();
        });
    }

    public void itemChanged(int changedSlotIndex) {
        if (!this.slotIndexes.contains(changedSlotIndex)) {
            return;
        }
        if (this.haveRenderedItemsChanged()) {
            this.updateFullRenderInfo();
        }
    }

    @Override
    public Optional<Integer> getSlotColor(int slotNumber) {
        return this.slotIndexes.contains(slotNumber) ? Optional.of(ColorHelper.getColor(this.color.m_41068_())) : Optional.empty();
    }
}

