/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.quark;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class TransferMessage {
    private final boolean isRestock;
    private final boolean smartTransfer;

    public TransferMessage(boolean isRestock, boolean smartTransfer) {
        this.isRestock = isRestock;
        this.smartTransfer = smartTransfer;
    }

    public static void encode(TransferMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeBoolean(msg.isRestock);
        packetBuffer.writeBoolean(msg.smartTransfer);
    }

    public static TransferMessage decode(FriendlyByteBuf packetBuffer) {
        return new TransferMessage(packetBuffer.readBoolean(), packetBuffer.readBoolean());
    }

    static void onMessage(TransferMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TransferMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, TransferMessage msg) {
        AbstractContainerMenu abstractContainerMenu;
        if (player == null || !((abstractContainerMenu = player.f_36096_) instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase storageMenu = (StorageContainerMenuBase)abstractContainerMenu;
        Object storageWrapper = storageMenu.getStorageWrapper();
        if (msg.isRestock) {
            player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(playerInv -> InventoryHelper.transfer((IItemHandler)storageWrapper.getInventoryHandler(), new FilteredItemHandler<IItemHandler>((IItemHandler)playerInv, msg.smartTransfer), s -> {}));
        } else {
            Inventory inv = player.m_150109_();
            FilteredStorageItemHandler targetInventory = new FilteredStorageItemHandler((IStorageWrapper)storageWrapper, msg.smartTransfer);
            for (int i = Inventory.m_36059_(); i < inv.f_35974_.size(); ++i) {
                ItemStack stackAt = inv.m_8020_(i);
                if (stackAt.m_41619_()) continue;
                inv.m_6836_(i, targetInventory.insertItem(stackAt, false));
            }
        }
    }

    private static class FilteredStorageItemHandler
    extends FilteredItemHandler<ITrackedContentsItemHandler>
    implements IItemHandlerSimpleInserter {
        private final IStorageWrapper storageWrapper;

        public FilteredStorageItemHandler(IStorageWrapper storageWrapper, boolean smart) {
            super(storageWrapper.getInventoryHandler(), smart);
            this.storageWrapper = storageWrapper;
        }

        @Override
        protected boolean matchesFilter(ItemStack stack) {
            return super.matchesFilter(stack) || this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).getFilterItemSlots().containsKey(stack.m_41720_());
        }

        @Override
        @Nonnull
        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            if (!this.smart || this.matchesFilter(stack)) {
                return ((ITrackedContentsItemHandler)this.itemHandler).insertItem(stack, simulate);
            }
            return stack;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            ((ITrackedContentsItemHandler)this.itemHandler).setStackInSlot(slot, stack);
        }
    }

    private static class FilteredItemHandler<T extends IItemHandler>
    implements IItemHandler {
        protected final T itemHandler;
        protected final boolean smart;

        public FilteredItemHandler(T itemHandler, boolean smart) {
            this.itemHandler = itemHandler;
            this.smart = smart;
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.smart || this.matchesFilter(stack)) {
                return this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected boolean matchesFilter(ItemStack stack) {
            int slots = this.getSlots();
            for (int i = 0; i < slots; ++i) {
                ItemStack stackAt = this.getStackInSlot(i);
                if (stackAt.m_41619_()) continue;
                boolean itemEqual = stack.m_41720_() == stackAt.m_41720_();
                boolean damageEqual = stack.m_41773_() == stackAt.m_41773_();
                boolean nbtEqual = ItemStack.m_41658_((ItemStack)stackAt, (ItemStack)stack);
                if (itemEqual && damageEqual && nbtEqual) {
                    return true;
                }
                if (!stack.m_41763_() || stack.m_41741_() != 1 || !itemEqual || !nbtEqual) continue;
                return true;
            }
            return false;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.itemHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.itemHandler.isItemValid(slot, stack);
        }
    }
}

