/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntComparators;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.HighStackCountSynchronizer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IFilterSlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageInventorySlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerRegistry;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerClientDataMessage;
import net.p3pp3rf1y.sophisticatedcore.settings.ISlotColorCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;

public abstract class StorageContainerMenuBase<S extends IStorageWrapper>
extends AbstractContainerMenu {
    public static final int NUMBER_OF_PLAYER_SLOTS = 36;
    public static final ResourceLocation EMPTY_UPGRADE_SLOT_BACKGROUND = new ResourceLocation("sophisticatedcore", "item/empty_upgrade_slot");
    protected static final String UPGRADE_ENABLED_TAG = "upgradeEnabled";
    protected static final String UPGRADE_SLOT_TAG = "upgradeSlot";
    protected static final String ACTION_TAG = "action";
    protected static final String OPEN_TAB_ID_TAG = "openTabId";
    protected static final String SORT_BY_TAG = "sortBy";
    private static final Method ON_SWAP_CRAFT = ObfuscationReflectionHelper.findMethod(Slot.class, (String)"m_6405_", (Class[])new Class[]{Integer.TYPE});
    public final NonNullList<ItemStack> lastUpgradeSlots = NonNullList.m_122779_();
    public final List<Slot> upgradeSlots = Lists.newArrayList();
    public final NonNullList<ItemStack> remoteUpgradeSlots = NonNullList.m_122779_();
    public final NonNullList<ItemStack> lastRealSlots = NonNullList.m_122779_();
    public final List<Slot> realInventorySlots = Lists.newArrayList();
    private final Map<Integer, UpgradeContainerBase<?, ?>> upgradeContainers = new LinkedHashMap();
    private final NonNullList<ItemStack> remoteRealSlots = NonNullList.m_122779_();
    protected final Player player;
    protected final S storageWrapper;
    protected final IStorageWrapper parentStorageWrapper;
    private final Map<Integer, ItemStack> slotStacksToUpdate = new HashMap<Integer, ItemStack>();
    private final int storageItemSlotIndex;
    private final boolean shouldLockStorageItemSlot;
    private int storageItemSlotNumber = -1;
    private Consumer<StorageContainerMenuBase<?>> upgradeChangeListener = null;
    private boolean isUpdatingFromPacket = false;
    private long errorResultExpirationTime = 0L;
    @Nullable
    private UpgradeSlotChangeResult errorUpgradeSlotChangeResult;
    private CompoundTag lastSettingsNbt = null;

    protected StorageContainerMenuBase(MenuType<?> pMenuType, int pContainerId, Player player, S storageWrapper, IStorageWrapper parentStorageWrapper, int storageItemSlotIndex, boolean shouldLockStorageItemSlot) {
        super(pMenuType, pContainerId);
        this.player = player;
        this.storageWrapper = storageWrapper;
        this.parentStorageWrapper = parentStorageWrapper;
        this.storageItemSlotIndex = storageItemSlotIndex;
        this.shouldLockStorageItemSlot = shouldLockStorageItemSlot;
        this.removeOpenTabIfKeepOff();
        storageWrapper.fillWithLoot(player);
        this.initSlotsAndContainers(player, storageItemSlotIndex, shouldLockStorageItemSlot);
    }

    public abstract Optional<BlockPos> getBlockPosition();

    protected void initSlotsAndContainers(Player player, int storageItemSlotIndex, boolean shouldLockStorageItemSlot) {
        this.addStorageInventorySlots();
        this.addPlayerInventorySlots(player.m_150109_(), storageItemSlotIndex, shouldLockStorageItemSlot);
        this.addUpgradeSlots();
        this.addUpgradeSettingsContainers(player);
    }

    public S getStorageWrapper() {
        return this.storageWrapper;
    }

    protected void addUpgradeSettingsContainers(Player player) {
        UpgradeHandler upgradeHandler = this.storageWrapper.getUpgradeHandler();
        upgradeHandler.getSlotWrappers().forEach((slot, wrapper) -> UpgradeContainerRegistry.instantiateContainer(player, slot, wrapper).ifPresent(container -> this.upgradeContainers.put((Integer)slot, (UpgradeContainerBase<?, ?>)container)));
        for (UpgradeContainerBase<?, ?> container : this.upgradeContainers.values()) {
            container.getSlots().forEach(this::addUpgradeSlot);
            container.onInit();
        }
        this.storageWrapper.getOpenTabId().ifPresent(id -> {
            if (this.upgradeContainers.containsKey(id)) {
                this.upgradeContainers.get(id).setIsOpen(true);
            }
        });
    }

    private void addUpgradeSlots() {
        UpgradeHandler upgradeHandler = this.storageWrapper.getUpgradeHandler();
        int numberOfSlots = upgradeHandler.getSlots();
        if (numberOfSlots == 0) {
            return;
        }
        for (int slotIndex = 0; slotIndex < upgradeHandler.getSlots(); ++slotIndex) {
            this.addUpgradeSlot((Slot)this.instantiateUpgradeSlot(upgradeHandler, slotIndex));
        }
    }

    public int getColumnsTaken() {
        return this.storageWrapper.getColumnsTaken();
    }

    public Optional<UpgradeSlotChangeResult> getErrorUpgradeSlotChangeResult() {
        if (this.errorUpgradeSlotChangeResult != null && this.player.f_19853_.m_46467_() >= this.errorResultExpirationTime) {
            this.errorResultExpirationTime = 0L;
            this.errorUpgradeSlotChangeResult = null;
        }
        return Optional.ofNullable(this.errorUpgradeSlotChangeResult);
    }

    protected void sendStorageSettingsToClient() {
    }

    protected abstract StorageUpgradeSlot instantiateUpgradeSlot(UpgradeHandler var1, int var2);

    protected void addUpgradeSlot(Slot slot) {
        slot.f_40219_ = this.getTotalSlotsNumber();
        this.upgradeSlots.add(slot);
        this.lastUpgradeSlots.add((Object)ItemStack.f_41583_);
        this.remoteUpgradeSlots.add((Object)ItemStack.f_41583_);
    }

    protected void addNoSortSlot(Slot slot) {
        slot.f_40219_ = this.getInventorySlotsSize();
        this.realInventorySlots.add(slot);
        this.lastRealSlots.add((Object)ItemStack.f_41583_);
        this.remoteRealSlots.add((Object)ItemStack.f_41583_);
    }

    protected Slot m_38897_(Slot slot) {
        slot.f_40219_ = this.getInventorySlotsSize();
        this.f_38839_.add((Object)slot);
        this.f_38841_.add((Object)ItemStack.f_41583_);
        this.f_150394_.add((Object)ItemStack.f_41583_);
        this.realInventorySlots.add(slot);
        this.lastRealSlots.add((Object)ItemStack.f_41583_);
        this.remoteRealSlots.add((Object)ItemStack.f_41583_);
        return slot;
    }

    public int getInventorySlotsSize() {
        return this.realInventorySlots.size();
    }

    public int getNumberOfStorageInventorySlots() {
        return this.storageWrapper.getInventoryHandler().getSlots();
    }

    public int getNumberOfUpgradeSlots() {
        return this.storageWrapper.getUpgradeHandler().getSlots();
    }

    public Map<Integer, UpgradeContainerBase<?, ?>> getUpgradeContainers() {
        return this.upgradeContainers;
    }

    protected void addStorageInventorySlots() {
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        Set<Integer> noSortSlotIndexes = this.getNoSortSlotIndexes();
        for (int slotIndex = 0; slotIndex < inventoryHandler.getSlots(); ++slotIndex) {
            int finalSlotIndex = slotIndex;
            StorageInventorySlot slot = new StorageInventorySlot(this.player.f_19853_.f_46443_, (IStorageWrapper)this.storageWrapper, inventoryHandler, finalSlotIndex);
            if (noSortSlotIndexes.contains(slotIndex)) {
                this.addNoSortSlot((Slot)slot);
                continue;
            }
            this.m_38897_((Slot)slot);
        }
    }

    protected void addPlayerInventorySlots(Inventory playerInventory, int storageItemSlotIndex, boolean shouldLockStorageItemSlot) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slotIndex = j + i * 9 + 9;
                Slot slot = this.addStorageItemSafeSlot(playerInventory, slotIndex, storageItemSlotIndex, shouldLockStorageItemSlot);
                this.addSlotAndUpdateStorageItemSlotNumber(storageItemSlotIndex, shouldLockStorageItemSlot, slotIndex, slot);
            }
        }
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            Slot slot = this.addStorageItemSafeSlot(playerInventory, slotIndex, storageItemSlotIndex, shouldLockStorageItemSlot);
            this.addSlotAndUpdateStorageItemSlotNumber(storageItemSlotIndex, shouldLockStorageItemSlot, slotIndex, slot);
        }
    }

    private Slot addStorageItemSafeSlot(Inventory playerInventory, int slotIndex, int storageItemSlotIndex, boolean shouldLockStorageItemSlot) {
        Slot slot = shouldLockStorageItemSlot && slotIndex == storageItemSlotIndex ? new Slot((Container)playerInventory, slotIndex, 0, 0){

            public boolean m_8010_(Player playerIn) {
                return false;
            }
        } : new Slot((Container)playerInventory, slotIndex, 0, 0);
        return this.m_38897_(slot);
    }

    public void closeScreenIfSomethingMessedWithStorageItemStack() {
        if (!this.isClientSide() && this.storageItemHasChanged()) {
            this.player.m_6915_();
        }
    }

    protected boolean isClientSide() {
        return this.player.f_19853_.f_46443_;
    }

    private void addSlotAndUpdateStorageItemSlotNumber(int storageItemSlotIndex, boolean lockStorageItemSlot, int slotIndex, Slot slot) {
        if (lockStorageItemSlot && slotIndex == storageItemSlotIndex) {
            this.storageItemSlotNumber = slot.f_40219_;
        }
    }

    public int getNumberOfRows() {
        return this.storageWrapper.getNumberOfSlotRows();
    }

    public int getFirstUpgradeSlot() {
        return this.getInventorySlotsSize();
    }

    public boolean isFirstLevelStorage() {
        return this.parentStorageWrapper == NoopStorageWrapper.INSTANCE;
    }

    public void m_182410_(int stateId, List<ItemStack> items, ItemStack carried) {
        this.storageWrapper.setPersistent(this.player.f_19853_.f_46443_);
        this.isUpdatingFromPacket = true;
        super.m_182410_(stateId, items, carried);
        this.isUpdatingFromPacket = false;
        this.storageWrapper.setPersistent(true);
        this.storageWrapper.getInventoryHandler().saveInventory();
        this.storageWrapper.getUpgradeHandler().saveInventory();
    }

    protected boolean isUpgradeSettingsSlot(int index) {
        return index >= this.getNumberOfStorageInventorySlots() + this.getNumberOfUpgradeSlots() + 36;
    }

    public boolean isStorageInventorySlot(int index) {
        return index >= 0 && index < this.getNumberOfStorageInventorySlots();
    }

    protected boolean isUpgradeSlot(int index) {
        return index >= this.getFirstUpgradeSlot() && index - this.getFirstUpgradeSlot() < this.getNumberOfUpgradeSlots();
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        Slot slot2;
        if (this.isUpgradeSettingsSlot(slotId) && this.m_38853_(slotId) instanceof IFilterSlot && this.m_38853_(slotId).m_5857_(this.m_142621_())) {
            Slot slot2 = this.m_38853_(slotId);
            ItemStack cursorStack = this.m_142621_().m_41777_();
            if (cursorStack.m_41613_() > 1) {
                cursorStack.m_41764_(1);
            }
            slot2.m_5852_(cursorStack);
            return;
        }
        if (this.isUpgradeSlot(slotId) && (slot2 = this.m_38853_(slotId)) instanceof StorageUpgradeSlot) {
            StorageUpgradeSlot slot3 = (StorageUpgradeSlot)slot2;
            ItemStack slotStack = slot3.m_7993_();
            if (slot3.m_5857_(this.m_142621_())) {
                ItemStack cursorStack = this.m_142621_();
                IUpgradeItem upgradeItem = (IUpgradeItem)cursorStack.m_41720_();
                int newColumnsTaken = upgradeItem.getInventoryColumnsTaken();
                int currentColumnsTaken = 0;
                if (!slotStack.m_41619_()) {
                    currentColumnsTaken = ((IUpgradeItem)slotStack.m_41720_()).getInventoryColumnsTaken();
                }
                if (this.needsSlotsThatAreOccupied(cursorStack, currentColumnsTaken, slot3, newColumnsTaken)) {
                    return;
                }
                int columnsToRemove = newColumnsTaken - currentColumnsTaken;
                if (slotStack.m_41619_() || slot3.canSwapStack(player, cursorStack)) {
                    this.m_142503_(slotStack);
                    slot3.m_5852_(cursorStack);
                    this.updateColumnsTaken(columnsToRemove);
                    slot3.m_6654_();
                }
            } else if ((this.m_142621_().m_41619_() || slot3.m_5857_(this.m_142621_())) && !slotStack.m_41619_() && slot3.m_8010_(player)) {
                int k2 = dragType == 0 ? Math.min(slotStack.m_41613_(), slotStack.m_41741_()) : Math.min(slotStack.m_41741_() + 1, slotStack.m_41613_() + 1) / 2;
                int columnsTaken = ((IUpgradeItem)slotStack.m_41720_()).getInventoryColumnsTaken();
                if (clickType == ClickType.QUICK_MOVE) {
                    this.m_7648_(player, slotId);
                } else {
                    this.m_142503_(slot3.m_6201_(k2));
                }
                this.updateColumnsTaken(-columnsTaken);
                slot3.m_142406_(player, this.m_142621_());
            }
            return;
        }
        if (this.isOverflowLogicSlotAndAction(slotId, clickType) && this.handleOverflow(slotId, clickType, dragType, player)) {
            return;
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public boolean m_207775_(int slotIndex) {
        return slotIndex == -1 || slotIndex == -999 || slotIndex < this.getTotalSlotsNumber();
    }

    private boolean handleOverflow(int slotId, ClickType clickType, int dragType, Player player) {
        ItemStack cursorStack = clickType == ClickType.SWAP ? player.m_150109_().m_8020_(dragType) : this.m_142621_();
        Consumer<ItemStack> updateCursorStack = clickType == ClickType.SWAP ? s -> player.m_150109_().m_6836_(dragType, s) : arg_0 -> ((StorageContainerMenuBase)this).m_142503_(arg_0);
        Slot slot = this.m_38853_(slotId);
        if (clickType != ClickType.SWAP && cursorStack.m_41619_() || !slot.m_5857_(cursorStack)) {
            return false;
        }
        ItemStack slotStack = slot.m_7993_();
        if (slotStack.m_41619_() || slot.m_8010_(player) && slotStack.m_41720_() != cursorStack.m_41720_() && cursorStack.m_41613_() <= slot.m_5866_(cursorStack) && slotStack.m_41613_() <= slotStack.m_41741_()) {
            return this.processOverflowIfSlotWithSameItemFound(slotId, cursorStack, updateCursorStack);
        }
        if (slotStack.m_41720_() == cursorStack.m_41720_()) {
            return this.processOverflowForAnythingOverSlotMaxSize(cursorStack, updateCursorStack, slot, slotStack);
        }
        return false;
    }

    private boolean processOverflowForAnythingOverSlotMaxSize(ItemStack cursorStack, Consumer<ItemStack> updateCursorStack, Slot slot, ItemStack slotStack) {
        int remainingSpaceInSlot = slot.m_5866_(cursorStack) - slotStack.m_41613_();
        if (remainingSpaceInSlot < cursorStack.m_41613_()) {
            ItemStack overflow = cursorStack.m_41777_();
            int overflowCount = cursorStack.m_41613_() - remainingSpaceInSlot;
            overflow.m_41764_(overflowCount);
            ItemStack result = this.processOverflowLogic(overflow);
            if (result.m_41613_() < overflowCount) {
                cursorStack.m_41774_(overflowCount - result.m_41613_());
                if (cursorStack.m_41619_()) {
                    updateCursorStack.accept(ItemStack.f_41583_);
                    return true;
                }
                updateCursorStack.accept(cursorStack);
            }
        }
        return false;
    }

    private boolean processOverflowIfSlotWithSameItemFound(int slotId, ItemStack cursorStack, Consumer<ItemStack> updateCursorStack) {
        for (IOverflowResponseUpgrade overflowUpgrade : this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(IOverflowResponseUpgrade.class)) {
            if (!overflowUpgrade.stackMatchesFilter(cursorStack) || !overflowUpgrade.worksInGui() || !this.findSlotWithMatchingStack(slotId, cursorStack, updateCursorStack, overflowUpgrade)) continue;
            return true;
        }
        return false;
    }

    private boolean findSlotWithMatchingStack(int slotId, ItemStack cursorStack, Consumer<ItemStack> updateCursorStack, IOverflowResponseUpgrade overflowUpgrade) {
        for (int slotIndex = 0; slotIndex < this.getNumberOfStorageInventorySlots(); ++slotIndex) {
            if (slotIndex == slotId || !overflowUpgrade.stackMatchesFilterStack(this.m_38853_(slotIndex).m_7993_(), cursorStack)) continue;
            ItemStack result = cursorStack;
            result = overflowUpgrade.onOverflow(result);
            updateCursorStack.accept(result);
            if (!result.m_41619_()) continue;
            return true;
        }
        return false;
    }

    private boolean isOverflowLogicSlotAndAction(int slotId, ClickType clickType) {
        return this.isStorageInventorySlot(slotId) && (clickType == ClickType.SWAP || clickType == ClickType.PICKUP);
    }

    protected void updateColumnsTaken(int columnsToRemove) {
        if (columnsToRemove != 0) {
            this.storageWrapper.setColumnsTaken(Math.max(0, this.storageWrapper.getColumnsTaken() + columnsToRemove), true);
            this.storageWrapper.onContentsNbtUpdated();
            this.refreshAllSlots();
        }
    }

    protected boolean needsSlotsThatAreOccupied(ItemStack cursorStack, int currentColumnsTaken, StorageUpgradeSlot upgradeSlot, int newColumnsTaken) {
        if (currentColumnsTaken >= newColumnsTaken) {
            return false;
        }
        int slotsToCheck = (newColumnsTaken - currentColumnsTaken) * this.getNumberOfRows();
        InventoryHandler invHandler = this.storageWrapper.getInventoryHandler();
        HashSet<Integer> errorSlots = new HashSet<Integer>();
        int slots = this.getNumberOfStorageInventorySlots();
        for (int slotIndex = slots - 1; slotIndex >= slots - slotsToCheck; --slotIndex) {
            if (invHandler.getStackInSlot(slotIndex).m_41619_()) continue;
            errorSlots.add(slotIndex);
        }
        if (!errorSlots.isEmpty()) {
            upgradeSlot.updateSlotChangeError(new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.needs_occupied_inventory_slots", slotsToCheck, cursorStack.m_41786_()), Collections.emptySet(), errorSlots, Collections.emptySet()));
            return true;
        }
        return false;
    }

    public int getUpgradeSlotsSize() {
        return this.upgradeSlots.size();
    }

    public List<Integer> getSlotOverlayColors(int slot) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        this.storageWrapper.getSettingsHandler().getCategoriesThatImplement(ISlotColorCategory.class).forEach(c -> c.getSlotColor(slot).ifPresent(ret::add));
        return ret;
    }

    public Optional<UpgradeContainerBase<?, ?>> getOpenContainer() {
        return this.storageWrapper.getOpenTabId().flatMap(id -> this.upgradeContainers.containsKey(id) ? Optional.of(this.upgradeContainers.get(id)) : Optional.empty());
    }

    protected void sendToServer(Consumer<CompoundTag> addData) {
        CompoundTag data = new CompoundTag();
        addData.accept(data);
        SophisticatedCore.PACKET_HANDLER.sendToServer(new SyncContainerClientDataMessage(data));
    }

    public void setUpgradeEnabled(int upgradeSlot, boolean enabled) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.storageWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return;
        }
        if (this.isClientSide()) {
            this.sendToServer(data -> {
                data.m_128379_(UPGRADE_ENABLED_TAG, enabled);
                data.m_128405_(UPGRADE_SLOT_TAG, upgradeSlot);
            });
        }
        slotWrappers.get(upgradeSlot).setEnabled(enabled);
    }

    public boolean getUpgradeEnabled(int upgradeSlot) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.storageWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return false;
        }
        return slotWrappers.get(upgradeSlot).isEnabled();
    }

    public boolean canDisableUpgrade(int upgradeSlot) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.storageWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return false;
        }
        return slotWrappers.get(upgradeSlot).canBeDisabled();
    }

    public void sort() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.m_128359_(ACTION_TAG, "sort"));
            return;
        }
        this.storageWrapper.sort();
    }

    public void setOpenTabId(int tabId) {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.m_128405_(OPEN_TAB_ID_TAG, tabId));
        }
        if (tabId == -1) {
            this.storageWrapper.removeOpenTabId();
        } else {
            this.storageWrapper.setOpenTabId(tabId);
        }
    }

    public void removeOpenTabId() {
        this.setOpenTabId(-1);
    }

    public SortBy getSortBy() {
        return this.storageWrapper.getSortBy();
    }

    public void setSortBy(SortBy sortBy) {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.m_128359_(SORT_BY_TAG, sortBy.m_7912_()));
        }
        this.storageWrapper.setSortBy(sortBy);
    }

    public void handleMessage(CompoundTag data) {
        if (data.m_128441_("containerId")) {
            int containerId = data.m_128451_("containerId");
            if (this.upgradeContainers.containsKey(containerId)) {
                this.upgradeContainers.get(containerId).handleMessage(data);
            }
        } else if (data.m_128441_(OPEN_TAB_ID_TAG)) {
            this.setOpenTabId(data.m_128451_(OPEN_TAB_ID_TAG));
        } else if (data.m_128441_(SORT_BY_TAG)) {
            this.setSortBy(SortBy.fromName(data.m_128461_(SORT_BY_TAG)));
        } else if (data.m_128441_(ACTION_TAG)) {
            String actionName;
            switch (actionName = data.m_128461_(ACTION_TAG)) {
                case "sort": {
                    this.sort();
                    break;
                }
                case "openSettings": {
                    this.openSettings();
                    break;
                }
            }
        } else if (data.m_128441_(UPGRADE_ENABLED_TAG)) {
            this.setUpgradeEnabled(data.m_128451_(UPGRADE_SLOT_TAG), data.m_128471_(UPGRADE_ENABLED_TAG));
        }
    }

    public Optional<UpgradeContainerBase<?, ?>> getSlotUpgradeContainer(Slot slot) {
        if (this.isUpgradeSettingsSlot(slot.f_40219_)) {
            for (UpgradeContainerBase<?, ?> upgradeContainer : this.upgradeContainers.values()) {
                if (!upgradeContainer.containsSlot(slot)) continue;
                return Optional.of(upgradeContainer);
            }
        }
        return Optional.empty();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            Optional<UpgradeContainerBase<?, ?>> upgradeContainer = this.getSlotUpgradeContainer(slot);
            ItemStack slotStack = upgradeContainer.map(c -> c.getSlotStackToTransfer(slot)).orElse(slot.m_7993_());
            itemstack = slotStack.m_41777_();
            if (!this.mergeSlotStack(slot, index, slotStack)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_40234_(slotStack, itemstack);
            if (upgradeContainer.isPresent()) {
                upgradeContainer.ifPresent(c -> c.onTakeFromSlot(slot, player, slotStack));
            } else {
                slot.m_142406_(player, slotStack);
            }
        }
        return itemstack;
    }

    private boolean mergeSlotStack(Slot slot, int index, ItemStack slotStack) {
        if (this.isUpgradeSlot(index)) {
            return this.mergeStackToStorage(slotStack) || this.mergeStackToPlayersInventory(slotStack);
        }
        if (this.isStorageInventorySlot(index)) {
            if (this.shouldShiftClickIntoOpenTabFirst()) {
                return this.mergeStackToOpenUpgradeTab(slotStack) || this.mergeStackToPlayersInventory(slotStack);
            }
            return this.mergeStackToPlayersInventory(slotStack) || this.mergeStackToOpenUpgradeTab(slotStack);
        }
        if (this.isUpgradeSettingsSlot(index)) {
            if (this.getSlotUpgradeContainer(slot).map(c -> c.mergeIntoStorageFirst(slot)).orElse(true).booleanValue()) {
                return this.mergeStackToStorage(slotStack) || this.mergeStackToPlayersInventory(slotStack);
            }
            return this.mergeStackToPlayersInventory(slotStack) || this.mergeStackToStorage(slotStack);
        }
        if (this.shouldShiftClickIntoOpenTabFirst()) {
            return this.mergeStackToOpenUpgradeTab(slotStack) || this.mergeStackToUpgradeSlots(slotStack) || this.mergeStackToStorage(slotStack);
        }
        return this.mergeStackToUpgradeSlots(slotStack) || this.mergeStackToStorage(slotStack) || this.mergeStackToOpenUpgradeTab(slotStack);
    }

    private boolean shouldShiftClickIntoOpenTabFirst() {
        MainSettingsCategory category = this.storageWrapper.getSettingsHandler().getGlobalSettingsCategory();
        return SettingsManager.getSettingValue(this.player, category.getPlayerSettingsTagName(), category, SettingsManager.SHIFT_CLICK_INTO_OPEN_TAB_FIRST);
    }

    private boolean mergeStackToUpgradeSlots(ItemStack slotStack) {
        return !this.upgradeSlots.isEmpty() && this.m_38903_(slotStack, this.getInventorySlotsSize(), this.getInventorySlotsSize() + this.getNumberOfUpgradeSlots(), false);
    }

    private boolean mergeStackToOpenUpgradeTab(ItemStack slotStack) {
        return this.getOpenContainer().map(c -> {
            List<Slot> slots = c.getSlots();
            if (slots.isEmpty()) {
                return false;
            }
            int firstSlotIndex = slots.get((int)0).f_40219_;
            int lastSlotIndex = slots.get((int)(slots.size() - 1)).f_40219_;
            return this.mergeItemStack(slotStack, firstSlotIndex, lastSlotIndex + 1, false, true);
        }).orElse(false);
    }

    private boolean mergeStackToStorage(ItemStack slotStack) {
        return this.mergeItemStack(slotStack, 0, this.getNumberOfStorageInventorySlots(), false, false, true);
    }

    private boolean mergeStackToPlayersInventory(ItemStack slotStack) {
        return this.mergeItemStack(slotStack, this.getNumberOfStorageInventorySlots(), this.getInventorySlotsSize(), true, true);
    }

    public boolean isNotPlayersInventorySlot(int slotNumber) {
        return slotNumber < this.getNumberOfStorageInventorySlots() || slotNumber >= this.getInventorySlotsSize();
    }

    public Optional<ItemStack> getMemorizedStackInSlot(int slotId) {
        return this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).getSlotFilterItem(slotId).map(ItemStack::new);
    }

    public void setUpgradeChangeListener(Consumer<StorageContainerMenuBase<?>> upgradeChangeListener) {
        this.upgradeChangeListener = upgradeChangeListener;
    }

    public abstract void openSettings();

    protected abstract boolean storageItemHasChanged();

    public <T extends UpgradeContainerBase<?, ?>> Optional<T> getOpenOrFirstCraftingContainer() {
        UpgradeContainerBase<?, ?> firstContainer = null;
        for (UpgradeContainerBase<?, ?> container : this.upgradeContainers.values()) {
            if (!(container instanceof ICraftingContainer)) continue;
            if (container.isOpen()) {
                return Optional.of(container);
            }
            if (firstContainer != null) continue;
            firstContainer = container;
        }
        return Optional.ofNullable(firstContainer);
    }

    public int getTotalSlotsNumber() {
        return this.getInventorySlotsSize() + this.upgradeSlots.size();
    }

    protected void removeOpenTabIfKeepOff() {
        MainSettingsCategory category = this.storageWrapper.getSettingsHandler().getGlobalSettingsCategory();
        if (Boolean.FALSE.equals(SettingsManager.getSettingValue(this.player, category.getPlayerSettingsTagName(), category, SettingsManager.KEEP_TAB_OPEN))) {
            this.storageWrapper.removeOpenTabId();
        }
    }

    protected Set<Integer> getNoSortSlotIndexes() {
        SettingsHandler settingsHandler = this.storageWrapper.getSettingsHandler();
        HashSet<Integer> slotIndexesExcludedFromSort = new HashSet<Integer>();
        slotIndexesExcludedFromSort.addAll(settingsHandler.getTypeCategory(NoSortSettingsCategory.class).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(settingsHandler.getTypeCategory(MemorySettingsCategory.class).getSlotIndexes());
        return slotIndexesExcludedFromSort;
    }

    public void m_182423_() {
        this.broadcastFullStateOf(this.lastUpgradeSlots, this.upgradeSlots, this.getFirstUpgradeSlot());
        this.broadcastFullStateOf(this.lastRealSlots, this.realInventorySlots, 0);
        this.m_150429_();
    }

    private void broadcastFullStateOf(NonNullList<ItemStack> lastSlotsCollection, List<Slot> slotsCollection, int slotIndexOffset) {
        for (int i = 0; i < slotsCollection.size(); ++i) {
            ItemStack itemstack = slotsCollection.get(i).m_7993_();
            this.triggerSlotListeners(i, itemstack, () -> ((ItemStack)itemstack).m_41777_(), lastSlotsCollection, slotIndexOffset);
        }
    }

    protected void triggerSlotListeners(int stackIndex, ItemStack slotStack, Supplier<ItemStack> slotStackCopy, NonNullList<ItemStack> lastSlotsCollection, int slotIndexOffset) {
        ItemStack itemstack = (ItemStack)lastSlotsCollection.get(stackIndex);
        if (!ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)slotStack)) {
            boolean clientStackChanged = !slotStack.equals(itemstack, true);
            ItemStack stackCopy = slotStackCopy.get();
            lastSlotsCollection.set(stackIndex, (Object)stackCopy);
            if (clientStackChanged) {
                for (ContainerListener containerlistener : this.f_38848_) {
                    containerlistener.m_7934_((AbstractContainerMenu)this, stackIndex + slotIndexOffset, stackCopy);
                }
            }
        }
    }

    public void m_150429_() {
        int i;
        for (i = 0; i < this.getInventorySlotsSize(); ++i) {
            this.remoteRealSlots.set(i, (Object)this.realInventorySlots.get(i).m_7993_().m_41777_());
        }
        for (i = 0; i < this.upgradeSlots.size(); ++i) {
            this.remoteUpgradeSlots.set(i, (Object)this.upgradeSlots.get(i).m_7993_().m_41777_());
        }
        NonNullList allRemoteSlots = NonNullList.m_122779_();
        allRemoteSlots.addAll(this.remoteRealSlots);
        allRemoteSlots.addAll(this.remoteUpgradeSlots);
        this.f_150396_ = this.m_142621_().m_41777_();
        if (this.f_150397_ != null) {
            this.f_150397_.m_142589_((AbstractContainerMenu)this, allRemoteSlots, this.f_150396_, new int[0]);
        }
    }

    public void m_150404_(int slotIndex, ItemStack stack) {
        if (slotIndex < this.getInventorySlotsSize()) {
            this.remoteRealSlots.set(slotIndex, (Object)stack.m_41777_());
        } else {
            this.remoteUpgradeSlots.set(slotIndex, (Object)stack.m_41777_());
        }
    }

    public void m_182414_(int slotIndex, ItemStack stack) {
        if (slotIndex < this.getInventorySlotsSize()) {
            this.remoteRealSlots.set(slotIndex, (Object)stack);
        } else {
            this.remoteUpgradeSlots.set(slotIndex - this.getInventorySlotsSize(), (Object)stack);
        }
    }

    public OptionalInt m_182417_(Container container, int slotIdx) {
        for (int i = 0; i < this.getTotalSlotsNumber(); ++i) {
            Slot slot = this.m_38853_(i);
            if (slot.f_40218_ != container || slotIdx != slot.m_150661_()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private void refreshAllSlots() {
        this.f_38839_.clear();
        this.f_38841_.clear();
        this.realInventorySlots.clear();
        this.lastRealSlots.clear();
        this.remoteRealSlots.clear();
        this.upgradeSlots.clear();
        this.lastUpgradeSlots.clear();
        this.remoteUpgradeSlots.clear();
        this.upgradeContainers.clear();
        this.initSlotsAndContainers(this.player, this.storageItemSlotIndex, this.shouldLockStorageItemSlot);
    }

    protected ItemStack processOverflowLogic(ItemStack stack) {
        IOverflowResponseUpgrade overflowUpgrade;
        ItemStack result = stack;
        Iterator<IOverflowResponseUpgrade> iterator = this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(IOverflowResponseUpgrade.class).iterator();
        while (!(!iterator.hasNext() || (overflowUpgrade = iterator.next()).worksInGui() && (result = overflowUpgrade.onOverflow(result)).m_41619_())) {
        }
        return result;
    }

    private void onSwapCraft(Slot slot, int numItemsCrafted) {
        try {
            ON_SWAP_CRAFT.invoke((Object)slot, numItemsCrafted);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            SophisticatedCore.LOGGER.error("Error invoking onSwapCraft method in Slot class", (Throwable)e);
        }
    }

    protected void m_150430_(int slotId, int dragType, ClickType clickType, Player player) {
        block67: {
            block70: {
                ItemStack slotStack;
                ItemStack itemstack4;
                Slot slot2;
                Inventory inventory;
                block72: {
                    block71: {
                        block69: {
                            ClickAction clickaction;
                            block68: {
                                block66: {
                                    inventory = player.m_150109_();
                                    if (clickType != ClickType.QUICK_CRAFT) break block66;
                                    int i = this.f_38846_;
                                    this.f_38846_ = StorageContainerMenuBase.m_38947_((int)dragType);
                                    if ((i != 1 || this.f_38846_ != 2) && i != this.f_38846_) {
                                        this.m_38951_();
                                    } else if (this.m_142621_().m_41619_()) {
                                        this.m_38951_();
                                    } else if (this.f_38846_ == 0) {
                                        this.f_38845_ = StorageContainerMenuBase.m_38928_((int)dragType);
                                        if (StorageContainerMenuBase.m_38862_((int)this.f_38845_, (Player)player)) {
                                            this.f_38846_ = 1;
                                            this.f_38847_.clear();
                                        } else {
                                            this.m_38951_();
                                        }
                                    } else if (this.f_38846_ == 1) {
                                        ItemStack itemstack;
                                        Slot slot = this.m_38853_(slotId);
                                        if (StorageContainerMenuBase.canItemQuickReplace(slot, itemstack = this.m_142621_()) && slot.m_5857_(itemstack) && (this.f_38845_ == 2 || itemstack.m_41613_() > this.f_38847_.size()) && this.m_5622_(slot)) {
                                            this.f_38847_.add(slot);
                                        }
                                    } else if (this.f_38846_ == 2) {
                                        if (!this.f_38847_.isEmpty()) {
                                            if (this.f_38847_.size() == 1) {
                                                int l = ((Slot)this.f_38847_.iterator().next()).f_40219_;
                                                this.m_38951_();
                                                this.m_150399_(l, this.f_38845_, ClickType.PICKUP, player);
                                                return;
                                            }
                                            ItemStack carried = this.m_142621_().m_41777_();
                                            int j1 = this.m_142621_().m_41613_();
                                            for (Slot slot1 : this.f_38847_) {
                                                ItemStack itemstack1 = this.m_142621_();
                                                if (slot1 == null || !StorageContainerMenuBase.canItemQuickReplace(slot1, itemstack1) || !slot1.m_5857_(itemstack1) || this.f_38845_ != 2 && itemstack1.m_41613_() < this.f_38847_.size() || !this.m_5622_(slot1)) continue;
                                                ItemStack carriedCopy = carried.m_41777_();
                                                int j = slot1.m_6657_() ? slot1.m_7993_().m_41613_() : 0;
                                                StorageContainerMenuBase.m_38922_((Set)this.f_38847_, (int)this.f_38845_, (ItemStack)carriedCopy, (int)j);
                                                int slotStackLimit = slot1.m_5866_(carriedCopy);
                                                if (!(slot1 instanceof StorageInventorySlot) && slotStackLimit > carriedCopy.m_41741_()) {
                                                    slotStackLimit = carriedCopy.m_41741_();
                                                }
                                                if (carriedCopy.m_41613_() > slotStackLimit) {
                                                    carriedCopy.m_41764_(slotStackLimit);
                                                }
                                                j1 -= carriedCopy.m_41613_() - j;
                                                slot1.m_5852_(carriedCopy);
                                            }
                                            carried.m_41764_(j1);
                                            this.m_142503_(carried);
                                        }
                                        this.m_38951_();
                                    } else {
                                        this.m_38951_();
                                    }
                                    break block67;
                                }
                                if (this.f_38846_ == 0) break block68;
                                this.m_38951_();
                                break block67;
                            }
                            if (clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1) break block69;
                            ClickAction clickAction = clickaction = dragType == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                            if (slotId == -999) {
                                if (!this.m_142621_().m_41619_()) {
                                    if (clickaction == ClickAction.PRIMARY) {
                                        player.m_36176_(this.m_142621_(), true);
                                        this.m_142503_(ItemStack.f_41583_);
                                    } else {
                                        player.m_36176_(this.m_142621_().m_41620_(1), true);
                                    }
                                }
                            } else if (clickType == ClickType.QUICK_MOVE) {
                                if (slotId < 0) {
                                    return;
                                }
                                Slot slot6 = this.m_38853_(slotId);
                                if (!slot6.m_8010_(player)) {
                                    return;
                                }
                                if (this.isStorageInventorySlot(slotId)) {
                                    this.m_7648_(this.player, slotId).m_41777_();
                                } else {
                                    ItemStack itemstack8 = this.m_7648_(this.player, slotId);
                                    while (!itemstack8.m_41619_() && ItemStack.m_41746_((ItemStack)slot6.m_7993_(), (ItemStack)itemstack8)) {
                                        itemstack8 = this.m_7648_(this.player, slotId);
                                    }
                                }
                            } else {
                                if (slotId < 0) {
                                    return;
                                }
                                Slot slot7 = this.m_38853_(slotId);
                                ItemStack slotStack2 = slot7.m_7993_();
                                ItemStack carriedStack = this.m_142621_();
                                player.m_141945_(carriedStack, slot7.m_7993_(), clickaction);
                                if (!carriedStack.m_150926_(slot7, clickaction, player) && !slotStack2.m_150932_(carriedStack, slot7, clickaction, player, this.m_150446_())) {
                                    if (slotStack2.m_41619_()) {
                                        if (!carriedStack.m_41619_()) {
                                            int l2 = clickaction == ClickAction.PRIMARY ? carriedStack.m_41613_() : 1;
                                            this.m_142503_(slot7.m_150656_(carriedStack, l2));
                                        }
                                    } else if (slot7.m_8010_(player)) {
                                        if (carriedStack.m_41619_()) {
                                            int i3 = clickaction == ClickAction.PRIMARY ? Math.min(slotStack2.m_41613_(), slotStack2.m_41741_()) : Math.min(slotStack2.m_41741_() + 1, slotStack2.m_41613_() + 1) / 2;
                                            Optional optional1 = slot7.m_150641_(i3, Integer.MAX_VALUE, player);
                                            optional1.ifPresent(p_150421_ -> {
                                                this.m_142503_((ItemStack)p_150421_);
                                                slot7.m_142406_(player, p_150421_);
                                            });
                                        } else if (slot7.m_5857_(carriedStack)) {
                                            if (ItemStack.m_150942_((ItemStack)slotStack2, (ItemStack)carriedStack)) {
                                                int j3 = clickaction == ClickAction.PRIMARY ? carriedStack.m_41613_() : 1;
                                                this.m_142503_(slot7.m_150656_(carriedStack, j3));
                                            } else if (carriedStack.m_41613_() <= slot7.m_5866_(carriedStack) && slotStack2.m_41613_() <= slotStack2.m_41741_()) {
                                                slot7.m_5852_(carriedStack);
                                                this.m_142503_(slotStack2);
                                            }
                                        } else if (ItemStack.m_150942_((ItemStack)slotStack2, (ItemStack)carriedStack)) {
                                            Optional optional = slot7.m_150641_(slotStack2.m_41613_(), carriedStack.m_41741_() - carriedStack.m_41613_(), player);
                                            optional.ifPresent(p_150428_ -> {
                                                carriedStack.m_41769_(p_150428_.m_41613_());
                                                slot7.m_142406_(player, p_150428_);
                                            });
                                        }
                                    }
                                }
                                slot7.m_6654_();
                            }
                            break block67;
                        }
                        if (clickType != ClickType.SWAP) break block70;
                        slot2 = this.m_38853_(slotId);
                        itemstack4 = inventory.m_8020_(dragType);
                        slotStack = slot2.m_7993_();
                        if (itemstack4.m_41619_() && slotStack.m_41619_()) break block67;
                        if (!itemstack4.m_41619_()) break block71;
                        if (slot2.m_8010_(player)) {
                            if (slotStack.m_41613_() <= slotStack.m_41741_()) {
                                inventory.m_6836_(dragType, slotStack);
                                this.onSwapCraft(slot2, slotStack.m_41613_());
                                slot2.m_5852_(ItemStack.f_41583_);
                                slot2.m_142406_(player, slotStack);
                            } else {
                                inventory.m_6836_(dragType, slotStack.m_41620_(slotStack.m_41741_()));
                                slot2.m_6654_();
                            }
                        }
                        break block67;
                    }
                    if (!slotStack.m_41619_()) break block72;
                    if (slot2.m_5857_(itemstack4)) {
                        int l1 = slot2.m_5866_(itemstack4);
                        if (itemstack4.m_41613_() > l1) {
                            slot2.m_5852_(itemstack4.m_41620_(l1));
                        } else {
                            slot2.m_5852_(itemstack4);
                            inventory.m_6836_(dragType, ItemStack.f_41583_);
                        }
                    }
                    break block67;
                }
                if (slotStack.m_41613_() > slotStack.m_41741_() || !slot2.m_8010_(player) || !slot2.m_5857_(itemstack4)) break block67;
                int i2 = slot2.m_5866_(itemstack4);
                if (itemstack4.m_41613_() > i2) {
                    slot2.m_5852_(itemstack4.m_41620_(i2));
                    slot2.m_142406_(player, slotStack);
                    if (!inventory.m_36054_(slotStack)) {
                        player.m_36176_(slotStack, true);
                    }
                } else {
                    slot2.m_5852_(itemstack4);
                    inventory.m_6836_(dragType, slotStack);
                    slot2.m_142406_(player, slotStack);
                }
                break block67;
            }
            if (clickType == ClickType.CLONE && player.m_150110_().f_35937_ && this.m_142621_().m_41619_() && slotId >= 0) {
                Slot slot5 = this.m_38853_(slotId);
                if (slot5.m_6657_()) {
                    ItemStack itemstack6 = slot5.m_7993_().m_41777_();
                    itemstack6.m_41764_(itemstack6.m_41741_());
                    this.m_142503_(itemstack6);
                }
            } else if (clickType == ClickType.THROW && this.m_142621_().m_41619_() && slotId >= 0) {
                Slot slot4 = this.m_38853_(slotId);
                int i1 = dragType == 0 ? 1 : slot4.m_7993_().m_41613_();
                ItemStack itemstack8 = slot4.m_150647_(i1, slot4.m_7993_().m_41741_(), player);
                player.m_36176_(itemstack8, true);
            } else if (clickType == ClickType.PICKUP_ALL && slotId >= 0) {
                Slot slot3 = this.m_38853_(slotId);
                ItemStack carriedStack = this.m_142621_();
                if (!(carriedStack.m_41619_() || slot3.m_6657_() && slot3.m_8010_(player))) {
                    int k1 = dragType == 0 ? 0 : this.getInventorySlotsSize() - 1;
                    int j2 = dragType == 0 ? 1 : -1;
                    for (int k2 = 0; k2 < 2; ++k2) {
                        for (int k3 = k1; k3 >= 0 && k3 < this.getInventorySlotsSize() && carriedStack.m_41613_() < carriedStack.m_41741_(); k3 += j2) {
                            Slot slot8 = this.m_38853_(k3);
                            if (!slot8.m_6657_() || !StorageContainerMenuBase.canItemQuickReplace(slot8, carriedStack) || !slot8.m_8010_(player) || !this.m_5882_(carriedStack, slot8)) continue;
                            ItemStack itemstack12 = slot8.m_7993_();
                            if (k2 == 0 && itemstack12.m_41613_() == itemstack12.m_41741_()) continue;
                            ItemStack itemstack13 = slot8.m_150647_(itemstack12.m_41613_(), carriedStack.m_41741_() - carriedStack.m_41613_(), player);
                            carriedStack.m_41769_(itemstack13.m_41613_());
                        }
                    }
                    k1 = dragType == 0 ? 0 : this.upgradeSlots.size() - 1;
                    for (int j = 0; j < 2; ++j) {
                        for (int upgradeSlotId = k1; upgradeSlotId >= 0 && upgradeSlotId < this.upgradeSlots.size() && carriedStack.m_41613_() < carriedStack.m_41741_(); upgradeSlotId += j2) {
                            Slot upgradeSlot = this.upgradeSlots.get(upgradeSlotId);
                            if (!upgradeSlot.m_6657_() || !StorageContainerMenuBase.canItemQuickReplace(upgradeSlot, carriedStack) || !upgradeSlot.m_8010_(this.player) || !this.m_5882_(carriedStack, upgradeSlot)) continue;
                            ItemStack itemstack3 = upgradeSlot.m_7993_();
                            if (j == 0 && itemstack3.m_41613_() == itemstack3.m_41741_()) continue;
                            int l = Math.min(carriedStack.m_41741_() - carriedStack.m_41613_(), itemstack3.m_41613_());
                            ItemStack itemstack4 = upgradeSlot.m_6201_(l);
                            carriedStack.m_41769_(l);
                            if (itemstack4.m_41619_()) {
                                upgradeSlot.m_5852_(ItemStack.f_41583_);
                            }
                            upgradeSlot.m_142406_(this.player, itemstack4);
                        }
                    }
                }
            }
        }
        this.sendSlotUpdates();
    }

    public void sendSlotUpdates() {
        if (!this.player.f_19853_.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)this.player;
            this.slotStacksToUpdate.forEach((slot, stack) -> serverPlayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(serverPlayer.f_36096_.f_38840_, this.m_182425_(), slot.intValue(), stack)));
            this.slotStacksToUpdate.clear();
        }
    }

    public void m_6877_(Player player) {
        for (Slot slot : this.upgradeSlots) {
            if (slot instanceof StorageUpgradeSlot || !this.isInventorySlotInUpgradeTab(player, slot) || !this.shouldSlotItemBeDroppedFromStorage(slot)) continue;
            ItemStack slotStack = slot.m_7993_();
            slot.m_5852_(ItemStack.f_41583_);
            if (player.m_36356_(slotStack)) continue;
            player.m_36176_(slotStack, false);
        }
        super.m_6877_(player);
        if (!player.f_19853_.f_46443_) {
            this.removeOpenTabIfKeepOff();
        }
    }

    protected static int calculateMaxCountForStack(int slotLimit, ItemStack stack) {
        return slotLimit / 64 * stack.m_41741_();
    }

    protected boolean mergeItemStack(ItemStack sourceStack, int startIndex, int endIndex, boolean reverseDirection, boolean transferMaxStackSizeFromSource, boolean runOverflowLogic) {
        int toTransfer;
        boolean mergedSomething = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        int n = toTransfer = transferMaxStackSizeFromSource ? Math.min(sourceStack.m_41741_(), sourceStack.m_41613_()) : sourceStack.m_41613_();
        if (runOverflowLogic || sourceStack.m_41753_() || this.m_38853_(startIndex).m_6641_() > 64) {
            while (toTransfer > 0 && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                ItemStack destStack;
                Slot slot = this.m_38853_(i);
                if (slot.m_5857_(sourceStack) && !(destStack = slot.m_7993_()).m_41619_() && ItemStack.m_150942_((ItemStack)sourceStack, (ItemStack)destStack)) {
                    ItemStack result;
                    int maxSize;
                    int j = destStack.m_41613_() + toTransfer;
                    if (j <= (maxSize = StorageContainerMenuBase.calculateMaxCountForStack(slot.m_6641_(), sourceStack))) {
                        sourceStack.m_41774_(toTransfer);
                        destStack.m_41764_(j);
                        toTransfer = 0;
                        slot.m_6654_();
                        mergedSomething = true;
                    } else if (destStack.m_41613_() < maxSize) {
                        sourceStack.m_41774_(maxSize - destStack.m_41613_());
                        toTransfer -= maxSize - destStack.m_41613_();
                        destStack.m_41764_(maxSize);
                        slot.m_6654_();
                        mergedSomething = true;
                    }
                    if (runOverflowLogic && !sourceStack.m_41619_() && (result = this.processOverflowLogic(sourceStack)) != sourceStack) {
                        sourceStack.m_41764_(result.m_41613_());
                        mergedSomething = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (toTransfer > 0) {
            int firstIndex = reverseDirection ? endIndex - 1 : startIndex;
            int increment = reverseDirection ? -1 : 1;
            MemorySettingsCategory memory = this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
            int slotIndex = firstIndex;
            while ((reverseDirection ? slotIndex >= startIndex : slotIndex < endIndex) && toTransfer > 0) {
                ItemStack destStack;
                Slot slot;
                if (memory.getSlotIndexes().contains(slotIndex) && memory.matchesFilter(slotIndex, sourceStack) && (slot = this.m_38853_(slotIndex)).m_5857_(sourceStack) && (destStack = slot.m_7993_()).m_41619_()) {
                    slot.m_5852_(sourceStack.m_41620_(slot.m_6641_()));
                    slot.m_6654_();
                    toTransfer = sourceStack.m_41613_();
                    mergedSomething = true;
                }
                slotIndex += increment;
            }
        }
        if (toTransfer > 0) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot destSlot = this.m_38853_(i);
                ItemStack itemstack1 = destSlot.m_7993_();
                if (itemstack1.m_41619_() && destSlot.m_5857_(sourceStack) && !(destSlot instanceof IFilterSlot)) {
                    boolean errorMerging = false;
                    if (toTransfer > destSlot.m_6641_()) {
                        if (runOverflowLogic && this.processOverflowIfSlotWithSameItemFound(i, sourceStack, s -> {})) {
                            sourceStack.m_41774_(sourceStack.m_41613_());
                            mergedSomething = true;
                        } else {
                            destSlot.m_5852_(sourceStack.m_41620_(destSlot.m_6641_()));
                        }
                    } else if (this.isUpgradeSlot(i)) {
                        IUpgradeItem upgradeItem;
                        int newColumnsTaken;
                        StorageUpgradeSlot upgradeSlot = (StorageUpgradeSlot)this.m_38853_(i);
                        if (!this.needsSlotsThatAreOccupied(sourceStack, 0, upgradeSlot, newColumnsTaken = (upgradeItem = (IUpgradeItem)sourceStack.m_41720_()).getInventoryColumnsTaken())) {
                            destSlot.m_5852_(sourceStack.m_41620_(toTransfer));
                            this.updateColumnsTaken(newColumnsTaken);
                        } else {
                            errorMerging = true;
                        }
                    } else if (runOverflowLogic && this.processOverflowIfSlotWithSameItemFound(i, sourceStack, s -> {})) {
                        sourceStack.m_41774_(sourceStack.m_41613_());
                        mergedSomething = true;
                    } else {
                        destSlot.m_5852_(sourceStack.m_41620_(toTransfer));
                    }
                    if (!errorMerging) {
                        destSlot.m_6654_();
                        mergedSomething = true;
                        break;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return mergedSomething;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.mergeItemStack(stack, startIndex, endIndex, reverseDirection, false);
    }

    protected boolean mergeItemStack(ItemStack sourceStack, int startIndex, int endIndex, boolean reverseDirection, boolean transferMaxStackSizeFromSource) {
        return this.mergeItemStack(sourceStack, startIndex, endIndex, reverseDirection, transferMaxStackSizeFromSource, false);
    }

    public void m_150416_(ContainerSynchronizer synchronizer) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            super.m_150416_((ContainerSynchronizer)new HighStackCountSynchronizer(serverPlayer));
            return;
        }
        super.m_150416_(synchronizer);
    }

    public static boolean canItemQuickReplace(@Nullable Slot slot, ItemStack stack) {
        boolean flag;
        boolean bl = flag = slot == null || !slot.m_6657_();
        if (!flag && stack.m_41656_(slot.m_7993_()) && ItemStack.m_41658_((ItemStack)slot.m_7993_(), (ItemStack)stack)) {
            return slot.m_7993_().m_41613_() <= StorageContainerMenuBase.calculateMaxCountForStack(slot.m_6641_(), stack);
        }
        return flag;
    }

    public Slot m_38853_(int slotId) {
        if (slotId >= this.getInventorySlotsSize()) {
            return this.upgradeSlots.get(slotId - this.getInventorySlotsSize());
        }
        return this.realInventorySlots.get(slotId);
    }

    public void m_182406_(int slotId, int pStateId, ItemStack pStack) {
        if (this.getTotalSlotsNumber() > slotId) {
            super.m_182406_(slotId, pStateId, pStack);
        }
    }

    public void m_38946_() {
        this.closeScreenIfSomethingMessedWithStorageItemStack();
        this.m_150445_();
        this.broadcastChangesIn(this.lastUpgradeSlots, this.remoteUpgradeSlots, this.upgradeSlots, this.getFirstUpgradeSlot());
        this.broadcastChangesIn(this.lastRealSlots, this.remoteRealSlots, this.realInventorySlots, 0);
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.storageWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.storageWrapper.getSettingsHandler().getNbt().m_6426_();
            this.sendStorageSettingsToClient();
            this.refreshInventorySlotsIfNeeded();
        }
    }

    public Optional<ItemStack> getVisibleStorageItem() {
        return this.storageItemSlotNumber != -1 ? Optional.of(this.m_38853_(this.storageItemSlotNumber).m_7993_()) : Optional.empty();
    }

    private void broadcastChangesIn(NonNullList<ItemStack> lastSlotsCollection, NonNullList<ItemStack> remoteSlotsCollection, List<Slot> slotsCollection, int slotIndexOffset) {
        for (int i = 0; i < slotsCollection.size(); ++i) {
            ItemStack itemstack = slotsCollection.get(i).m_7993_();
            com.google.common.base.Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).m_41777_());
            this.triggerSlotListeners(i, itemstack, (Supplier<ItemStack>)supplier, lastSlotsCollection, slotIndexOffset);
            this.synchronizeSlotToRemote(i, itemstack, (Supplier<ItemStack>)supplier, remoteSlotsCollection, slotIndexOffset);
        }
    }

    private void synchronizeSlotToRemote(int slotIndex, ItemStack slotStack, Supplier<ItemStack> slotStackCopy, NonNullList<ItemStack> remoteSlotsCollection, int slotIndexOffset) {
        ItemStack itemstack;
        if (!this.f_150398_ && !ItemStack.m_41728_((ItemStack)(itemstack = (ItemStack)remoteSlotsCollection.get(slotIndex)), (ItemStack)slotStack)) {
            ItemStack stackCopy = slotStackCopy.get();
            remoteSlotsCollection.set(slotIndex, (Object)stackCopy);
            if (this.f_150397_ != null) {
                this.f_150397_.m_142074_((AbstractContainerMenu)this, slotIndex + slotIndexOffset, stackCopy);
            }
        }
    }

    protected void refreshInventorySlotsIfNeeded() {
        Set<Integer> noSortSlotIndexes = this.getNoSortSlotIndexes();
        boolean needRefresh = false;
        if (this.getInventorySlotsSize() - this.f_38839_.size() != noSortSlotIndexes.size()) {
            needRefresh = true;
        } else {
            for (Slot slot : this.realInventorySlots) {
                if (this.f_38839_.contains((Object)slot) || noSortSlotIndexes.contains(slot.f_40219_)) continue;
                needRefresh = true;
                break;
            }
        }
        if (!needRefresh) {
            return;
        }
        this.f_38839_.clear();
        this.f_38841_.clear();
        this.realInventorySlots.clear();
        this.lastRealSlots.clear();
        this.remoteRealSlots.clear();
        this.addStorageInventorySlots();
        this.addPlayerInventorySlots(this.player.m_150109_(), this.storageItemSlotIndex, this.shouldLockStorageItemSlot);
    }

    public NonNullList<ItemStack> m_38927_() {
        NonNullList list = NonNullList.m_122779_();
        this.realInventorySlots.forEach(slot -> list.add((Object)slot.m_7993_()));
        this.upgradeSlots.forEach(upgradeSlot -> list.add((Object)upgradeSlot.m_7993_()));
        return list;
    }

    public abstract boolean detectSettingsChangeAndReload();

    protected boolean shouldSlotItemBeDroppedFromStorage(Slot slot) {
        return false;
    }

    private boolean isInventorySlotInUpgradeTab(Player player, Slot slot) {
        return slot.m_8010_(player) && !(slot instanceof ResultSlot);
    }

    public void setSlotStackToUpdate(int slot, ItemStack stack) {
        this.slotStacksToUpdate.put(slot, stack);
    }

    public class StorageUpgradeSlot
    extends SlotItemHandler {
        private boolean wasEmpty;
        private final int slotIndex;

        public StorageUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
            super((IItemHandler)upgradeHandler, slotIndex, -15, 0);
            this.wasEmpty = false;
            this.slotIndex = slotIndex;
        }

        public void m_6654_() {
            super.m_6654_();
            if (!StorageContainerMenuBase.this.isUpdatingFromPacket && this.wasEmpty != this.m_7993_().m_41619_() || this.updateWrappersAndCheckForReloadNeeded()) {
                this.reloadUpgradeControl();
                if (!StorageContainerMenuBase.this.isFirstLevelStorage()) {
                    StorageContainerMenuBase.this.parentStorageWrapper.getUpgradeHandler().refreshUpgradeWrappers();
                }
                this.onUpgradeChanged();
            }
            this.wasEmpty = this.m_7993_().m_41619_();
        }

        protected void onUpgradeChanged() {
        }

        public boolean m_5857_(ItemStack stack) {
            if (stack.m_41619_() || !this.getItemHandler().isItemValid(this.slotIndex, stack)) {
                return false;
            }
            UpgradeSlotChangeResult result = ((IUpgradeItem)stack.m_41720_()).canAddUpgradeTo((IStorageWrapper)StorageContainerMenuBase.this.storageWrapper, stack, StorageContainerMenuBase.this.isFirstLevelStorage());
            this.updateSlotChangeError(result);
            return result.isSuccessful();
        }

        private void updateSlotChangeError(UpgradeSlotChangeResult result) {
            if (StorageContainerMenuBase.this.player.f_19853_.f_46443_ && !result.isSuccessful()) {
                StorageContainerMenuBase.this.errorUpgradeSlotChangeResult = result;
                StorageContainerMenuBase.this.errorResultExpirationTime = StorageContainerMenuBase.this.player.f_19853_.m_46467_() + 60L;
            }
        }

        public boolean m_8010_(Player player) {
            boolean ret = super.m_8010_(player);
            if (!ret) {
                return false;
            }
            UpgradeSlotChangeResult result = ((IUpgradeItem)this.m_7993_().m_41720_()).canRemoveUpgradeFrom((IStorageWrapper)StorageContainerMenuBase.this.storageWrapper);
            this.updateSlotChangeError(result);
            return result.isSuccessful();
        }

        public boolean canSwapStack(Player player, ItemStack stackToPut) {
            boolean ret = super.m_8010_(player);
            if (!ret) {
                return false;
            }
            UpgradeSlotChangeResult result = ((IUpgradeItem)this.m_7993_().m_41720_()).canSwapUpgradeFor(stackToPut, (IStorageWrapper)StorageContainerMenuBase.this.storageWrapper);
            this.updateSlotChangeError(result);
            return result.isSuccessful();
        }

        private boolean updateWrappersAndCheckForReloadNeeded() {
            int checkedContainersCount = 0;
            for (Map.Entry<Integer, IUpgradeWrapper> slotWrapper : StorageContainerMenuBase.this.storageWrapper.getUpgradeHandler().getSlotWrappers().entrySet()) {
                UpgradeContainerBase<?, ?> container = StorageContainerMenuBase.this.upgradeContainers.get(slotWrapper.getKey());
                if (slotWrapper.getValue().hideSettingsTab()) {
                    if (container == null) continue;
                    return true;
                }
                if (container == null || container.getUpgradeWrapper().isEnabled() != slotWrapper.getValue().isEnabled()) {
                    return true;
                }
                if (container.getUpgradeWrapper() == slotWrapper.getValue()) continue;
                if (container.getUpgradeWrapper().getUpgradeStack().m_41720_() != slotWrapper.getValue().getUpgradeStack().m_41720_()) {
                    return true;
                }
                container.setUpgradeWrapper(slotWrapper.getValue());
                ++checkedContainersCount;
            }
            return checkedContainersCount != StorageContainerMenuBase.this.upgradeContainers.size();
        }

        private void reloadUpgradeControl() {
            StorageContainerMenuBase.this.storageWrapper.removeOpenTabId();
            this.removeUpgradeSettingsSlots();
            StorageContainerMenuBase.this.upgradeContainers.clear();
            StorageContainerMenuBase.this.addUpgradeSettingsContainers(StorageContainerMenuBase.this.player);
            this.onUpgradesChanged();
        }

        private void removeUpgradeSettingsSlots() {
            ArrayList slotNumbersToRemove = new ArrayList();
            for (UpgradeContainerBase<?, ?> container : StorageContainerMenuBase.this.upgradeContainers.values()) {
                container.getSlots().forEach(slot -> {
                    int upgradeSlotIndex = slot.f_40219_ - StorageContainerMenuBase.this.getInventorySlotsSize();
                    slotNumbersToRemove.add(upgradeSlotIndex);
                    StorageContainerMenuBase.this.upgradeSlots.remove(slot);
                });
            }
            slotNumbersToRemove.sort(IntComparators.OPPOSITE_COMPARATOR);
            Iterator<UpgradeContainerBase<Object, Object>> iterator = slotNumbersToRemove.iterator();
            while (iterator.hasNext()) {
                int slotNumber = (Integer)((Object)iterator.next());
                StorageContainerMenuBase.this.lastUpgradeSlots.remove(slotNumber);
                StorageContainerMenuBase.this.remoteUpgradeSlots.remove(slotNumber);
            }
        }

        private void onUpgradesChanged() {
            if (StorageContainerMenuBase.this.upgradeChangeListener != null) {
                StorageContainerMenuBase.this.upgradeChangeListener.accept(StorageContainerMenuBase.this);
            }
        }

        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return new Pair((Object)InventoryMenu.f_39692_, (Object)EMPTY_UPGRADE_SLOT_BACKGROUND);
        }
    }
}

