/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SortButtonsPosition;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    private Config() {
    }

    static {
        Pair clientSpec = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpec.getRight();
        CLIENT = (Client)clientSpec.getLeft();
        Pair commonSpec = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpec.getRight();
        COMMON = (Common)commonSpec.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.EnumValue<SortButtonsPosition> sortButtonsPosition;
        public final ForgeConfigSpec.BooleanValue playButtonSound;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client Settings").push("client");
            this.sortButtonsPosition = builder.comment("Positions where sort buttons can display to help with conflicts with controls from other mods").defineEnum("sortButtonsPosition", (Enum)SortButtonsPosition.TITLE_LINE_RIGHT);
            this.playButtonSound = builder.comment("Whether click sound should play when custom buttons are clicked in gui").define("playButtonSound", true);
            builder.pop();
        }
    }

    public static class Common {
        public final EnabledItems enabledItems;

        public void onConfigReload(ModConfigEvent.Reloading event) {
            this.enabledItems.enabledMap.clear();
        }

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common Settings").push("common");
            this.enabledItems = new EnabledItems(builder);
        }

        public static class EnabledItems {
            private final ForgeConfigSpec.ConfigValue<List<String>> itemsEnableList;
            private final Map<ResourceLocation, Boolean> enabledMap = new ConcurrentHashMap<ResourceLocation, Boolean>();

            EnabledItems(ForgeConfigSpec.Builder builder) {
                this.itemsEnableList = builder.comment("Disable / enable any items here (disables their recipes)").define("enabledItems", new ArrayList());
            }

            public boolean isItemEnabled(Item item) {
                return RegistryHelper.getRegistryName(item).map(this::isItemEnabled).orElse(false);
            }

            public boolean isItemEnabled(ResourceLocation itemRegistryName) {
                if (!COMMON_SPEC.isLoaded()) {
                    return true;
                }
                if (this.enabledMap.isEmpty()) {
                    this.loadEnabledMap();
                }
                return this.enabledMap.computeIfAbsent(itemRegistryName, irn -> {
                    this.addEnabledItemToConfig(itemRegistryName);
                    return true;
                });
            }

            private void addEnabledItemToConfig(ResourceLocation itemRegistryName) {
                ((List)this.itemsEnableList.get()).add(itemRegistryName + "|true");
                COMMON_SPEC.save();
            }

            private void loadEnabledMap() {
                for (String itemEnabled : (List)this.itemsEnableList.get()) {
                    String[] data = itemEnabled.split("\\|");
                    if (data.length == 2) {
                        this.enabledMap.put(new ResourceLocation(data[0]), Boolean.valueOf(data[1]));
                        continue;
                    }
                    SophisticatedCore.LOGGER.error("Wrong data for enabledItems - expected registry name|true/false when {} was provided", (Object)itemEnabled);
                }
            }
        }
    }
}

