/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.impacts;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.config.BlockImpactList;
import com.endertech.minecraft.mods.adpother.impacts.AbstractImpacts;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class EnvironmentalImpacts
extends AbstractImpacts<BlockImpactList> {
    public EnvironmentalImpacts(UnitConfig config) {
        super(config);
        config.setCategoryComment(this.getHeadCategory(), "Action syntax: blockId -> ACTION \nReplacement syntax: blockId -> blockId \nSyntax with a threshold: pollutionThreshold% -> blockId -> ACTION or blockId \n\nPollution threshold is the minimum percentage of pollution to trigger the specified effect.\n\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n\nPossible actions (case sensitive): " + Args.join((Object[])Arrays.stream(BlockImpactList.ActionType.values()).filter(type -> type != BlockImpactList.ActionType.REPLACE).toArray()));
        for (Pollutant pollutant : AdPother.getInstance().pollutants.streamAll().toList()) {
            String category = this.getPollutantSubCategory(pollutant);
            EnumMap<AbstractImpacts.ImpactType, BlockImpactList> impactsBySpread = new EnumMap<AbstractImpacts.ImpactType, BlockImpactList>(AbstractImpacts.ImpactType.class);
            for (AbstractImpacts.ImpactType type2 : AbstractImpacts.ImpactType.values()) {
                impactsBySpread.put(type2, new BlockImpactList(config, category, type2.getName(), "Effects spreading through " + type2.getName() + "."));
            }
            this.impactsByPollutant.put(pollutant, impactsBySpread);
        }
        this.carbon(AbstractImpacts.ImpactType.CONTACT, "minecraft:water:* -> POLLUTE", "#minecraft:leaves -> KILL");
        this.carbon(AbstractImpacts.ImpactType.RAIN, "minecraft:grass_block:* -> BONEMEAL", "#minecraft:leaves -> BONEMEAL", "#minecraft:tall_flowers -> BONEMEAL");
        this.carbon(AbstractImpacts.ImpactType.AIR, "minecraft:grass:* -> BONEMEAL", "minecraft:bamboo:* -> BONEMEAL", "minecraft:fern:* -> BONEMEAL", "#minecraft:crops -> BONEMEAL", "#minecraft:saplings -> BONEMEAL");
        this.dust(AbstractImpacts.ImpactType.CONTACT, "minecraft:water:* -> POLLUTE", "minecraft:grass:* -> KILL", "minecraft:fern:* -> KILL", "minecraft:grass_block:* -> minecraft:dirt_path", "minecraft:farmland:* -> minecraft:coarse_dirt", "minecraft:dirt_path:* -> minecraft:coarse_dirt", "#minecraft:small_flowers -> KILL", "#minecraft:crops -> KILL", "#minecraft:saplings -> KILL");
        this.dust(AbstractImpacts.ImpactType.RAIN, "minecraft:coarse_dirt:* -> minecraft:gravel");
        this.sulfur(AbstractImpacts.ImpactType.CONTACT, "minecraft:water:* -> POLLUTE", "#minecraft:leaves -> KILL");
        this.sulfur(AbstractImpacts.ImpactType.RAIN, "minecraft:water:* -> POLLUTE", "minecraft:grass_block:* -> minecraft:podzol", "minecraft:farmland:* -> minecraft:podzol", "minecraft:dirt_path:* -> minecraft:podzol", "minecraft:bamboo:* -> KILL", "minecraft:tall_grass:* -> KILL", "#minecraft:tall_flowers -> KILL", "minecraft:large_fern:* -> KILL", "10% -> minecraft:hay_block:* -> KILL", "15% -> minecraft:stone -> minecraft:cobblestone", "#minecraft:leaves -> KILL");
        this.sulfur(AbstractImpacts.ImpactType.AIR, "minecraft:grass:* -> KILL", "minecraft:fern:* -> KILL", "minecraft:cactus:* -> KILL", "#minecraft:small_flowers -> KILL", "#minecraft:crops -> KILL", "#minecraft:saplings -> KILL");
    }

    public List<BlockImpactList.AbstractAction> getActionsFor(BlockState state, Pollutant<?> pollutant, AbstractImpacts.ImpactType type) {
        return this.getImpactsFor(pollutant, type).map(impacts -> impacts.getActionsFor(state)).orElse(Collections.emptyList());
    }

    public boolean canAffect(BlockState state, Pollutant<?> pollutant, AbstractImpacts.ImpactType type) {
        return !this.getActionsFor(state, pollutant, type).isEmpty();
    }

    public boolean tryAffect(ServerLevel world, BlockPos pos, BlockState state, Pollutant<?> pollutant, AbstractImpacts.ImpactType type) {
        List<BlockImpactList.AbstractAction> actions = this.getActionsFor(state, pollutant, type);
        if (actions.isEmpty()) {
            return false;
        }
        Lazy chunkPollution = Lazy.of(() -> pollutant.getPercentageAtChunk(world, pos));
        for (BlockImpactList.AbstractAction action : actions) {
            if (!action.threshold.equals((Object)Percentage.ZERO) && !action.threshold.isLessOrEqualTo((Object)((Percentage)chunkPollution.get()))) continue;
            return action.perform(world, pos, state);
        }
        return false;
    }
}

