/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.impacts;

import com.endertech.minecraft.forge.configs.AbstractParsableList;
import com.endertech.minecraft.forge.configs.ConfigCategory;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.IPostInit;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractImpacts<L extends AbstractParsableList>
implements IPostInit,
IHaveConfig {
    protected final Map<Pollutant<?>, EnumMap<ImpactType, L>> impactsByPollutant = new ConcurrentHashMap();
    private final UnitConfig config;

    protected Optional<L> getImpactsFor(Pollutant<?> pollutant, ImpactType type) {
        return Optional.ofNullable(this.impactsByPollutant.get(pollutant)).map(impactsBySpread -> (AbstractParsableList)impactsBySpread.get((Object)type));
    }

    public AbstractImpacts(UnitConfig config) {
        this.config = config;
    }

    protected String getHeadCategory() {
        return "Impacts";
    }

    protected String getPollutantSubCategory(Pollutant<?> pollutant) {
        return ConfigCategory.name().join(new String[]{this.getHeadCategory(), pollutant.getRegistryName().m_135815_()});
    }

    public UnitConfig getConfig() {
        return this.config;
    }

    public void onPostInit() {
        for (EnumMap<ImpactType, L> impactsBySpread : this.impactsByPollutant.values()) {
            for (AbstractParsableList impacts : impactsBySpread.values()) {
                impacts.loadData();
            }
        }
        this.saveConfig();
    }

    protected final void addDefault(Pollutant<?> pollutant, ImpactType type, String ... values) {
        this.getImpactsFor(pollutant, type).ifPresent(impacts -> impacts.addDefaultValues(values));
    }

    protected final void carbon(ImpactType type, String ... values) {
        this.addDefault(Pollutants.BuiltIn.CARBON.get(), type, values);
    }

    protected final void sulfur(ImpactType type, String ... values) {
        this.addDefault(Pollutants.BuiltIn.SULFUR.get(), type, values);
    }

    protected final void dust(ImpactType type, String ... values) {
        this.addDefault(Pollutants.BuiltIn.DUST.get(), type, values);
    }

    public static enum ImpactType implements IForgeEnum
    {
        CONTACT,
        RAIN,
        AIR;

    }
}

