/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.impacts;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.config.ImmuneEntityList;
import com.endertech.minecraft.mods.adpother.config.LivingEntityImpactList;
import com.endertech.minecraft.mods.adpother.impacts.AbstractImpacts;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class AbstractEntityImpacts
extends AbstractImpacts<LivingEntityImpactList> {
    protected final ImmuneEntityList immuneEntities;

    public AbstractEntityImpacts(UnitConfig config) {
        super(config);
        config.setCategoryComment(this.getHeadCategory(), "Syntax: effectId \nSyntax with a threshold: pollutionThreshold% -> effectId \n\nPollution threshold is the minimum percentage of pollution to trigger the specified effect.");
        this.immuneEntities = new ImmuneEntityList(config, this.getHeadCategory(), "List of entities with some immunity to pollution.");
        for (Pollutant pollutant : AdPother.getInstance().pollutants.streamAll().toList()) {
            String category = this.getPollutantSubCategory(pollutant);
            EnumMap<AbstractImpacts.ImpactType, LivingEntityImpactList> impactsBySpread = new EnumMap<AbstractImpacts.ImpactType, LivingEntityImpactList>(AbstractImpacts.ImpactType.class);
            for (AbstractImpacts.ImpactType type : AbstractImpacts.ImpactType.values()) {
                impactsBySpread.put(type, new LivingEntityImpactList(config, category, type.getName(), "Effects spreading through " + type.getName() + "."));
            }
            this.impactsByPollutant.put(pollutant, impactsBySpread);
        }
    }

    public boolean isImmune(Entity entity, Percentage pollution) {
        return this.immuneEntities.isImmune(entity, pollution);
    }

    public boolean canAffect(Entity entity, Pollutant<?> pollutant, AbstractImpacts.ImpactType impact, Percentage pollution) {
        return !this.getActiveEffectsFor(entity, pollutant, impact, pollution).isEmpty();
    }

    public List<LivingEntityImpactList.EntityEffect> getActiveEffectsFor(Entity entity, Pollutant<?> pollutant, AbstractImpacts.ImpactType impact, Percentage pollution) {
        if (entity instanceof LivingEntity && !this.isImmune(entity, pollution)) {
            return this.getImpactsFor(pollutant, impact).map(impacts -> impacts.getActiveEffects(pollution)).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public int tryAffect(Entity entity, Pollutant<?> pollutant, AbstractImpacts.ImpactType impact, Percentage pollution) {
        int count = 0;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (LivingEntityImpactList.EntityEffect effect : this.getActiveEffectsFor((Entity)living, pollutant, impact, pollution)) {
                if (!effect.applyOn(living, pollution)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public void onPostInit() {
        this.immuneEntities.loadData();
        super.onPostInit();
    }
}

