/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EngineersBlueprintItem
extends IEBaseItem {
    public EngineersBlueprintItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Nonnull
    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        String key = EngineersBlueprintItem.getCategory(stack);
        if (!key.isEmpty() && BlueprintCraftingRecipe.recipeCategories.contains(key)) {
            String formatted;
            String formatKey = "desc.immersiveengineering.info.blueprint." + key;
            if (formatKey.equals(formatted = I18n.m_118938_((String)formatKey, (Object[])new Object[0]))) {
                list.add((Component)new TextComponent(key));
            } else {
                list.add((Component)new TranslatableComponent(formatKey));
            }
            if (world != null && Screen.m_96638_()) {
                list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.blueprint.creates1"));
                BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(world, key);
                if (recipes.length > 0) {
                    for (BlueprintCraftingRecipe recipe : recipes) {
                        list.add((Component)new TextComponent(" ").m_7220_(((ItemStack)recipe.output.get()).m_41786_()));
                    }
                }
            } else {
                list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.blueprint.creates0"));
            }
        }
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        if (this.m_41389_(tab)) {
            for (String key : BlueprintCraftingRecipe.recipeCategories) {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemNBTHelper.putString(stack, "blueprint", key);
                list.add((Object)stack);
            }
        }
    }

    @Nonnull
    public static BlueprintCraftingRecipe[] getRecipes(Level level, ItemStack stack) {
        return BlueprintCraftingRecipe.findRecipes(level, EngineersBlueprintItem.getCategory(stack));
    }

    public static String getCategory(ItemStack stack) {
        return ItemNBTHelper.getString(stack, "blueprint");
    }
}

