/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.gui.BlockEntityInventory;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.network.MessageContainerData;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class IEBaseContainer<T extends BlockEntity>
extends AbstractContainerMenu {
    public T tile;
    @Nullable
    public Container inv;
    public int slotCount;
    private final List<GenericContainerData<?>> genericData = new ArrayList();
    private final List<ServerPlayer> usingPlayers = new ArrayList<ServerPlayer>();

    public IEBaseContainer(MenuType<?> type, T tile, int id) {
        super(type, id);
        this.tile = tile;
        if (tile instanceof IIEInventory) {
            this.inv = new BlockEntityInventory((BlockEntity)tile, this);
        }
    }

    public boolean m_6875_(@Nonnull Player player) {
        return this.inv != null && this.inv.m_6542_(player);
    }

    public void addGenericData(GenericContainerData<?> newData) {
        this.genericData.add(newData);
    }

    public void m_38946_() {
        super.m_38946_();
        ArrayList toSync = new ArrayList();
        for (int i = 0; i < this.genericData.size(); ++i) {
            GenericContainerData<?> data = this.genericData.get(i);
            if (!data.needsUpdate()) continue;
            toSync.add(Pair.of((Object)i, data.dataPair()));
        }
        if (!toSync.isEmpty()) {
            for (ServerPlayer player : this.usingPlayers) {
                ImmersiveEngineering.packetHandler.sendTo((Object)new MessageContainerData(toSync), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public void receiveSync(List<Pair<Integer, GenericDataSerializers.DataPair<?>>> synced) {
        for (Pair<Integer, GenericDataSerializers.DataPair<?>> syncElement : synced) {
            this.genericData.get((Integer)syncElement.getFirst()).processSync(((GenericDataSerializers.DataPair)syncElement.getSecond()).data());
        }
    }

    public void m_150399_(int id, int dragType, ClickType clickType, Player player) {
        Slot slot;
        Slot slot2 = slot = id < 0 ? null : (Slot)this.f_38839_.get(id);
        if (!(slot instanceof IESlot.ItemHandlerGhost)) {
            super.m_150399_(id, dragType, clickType, player);
            return;
        }
        ItemStack stackSlot = slot.m_7993_();
        if (dragType == 2) {
            slot.m_5852_(ItemStack.f_41583_);
        } else if (dragType == 0 || dragType == 1) {
            ItemStack stackHeld = this.m_142621_();
            int amount = Math.min(slot.m_6641_(), stackHeld.m_41613_());
            if (dragType == 1) {
                amount = 1;
            }
            if (stackSlot.m_41619_()) {
                if (!stackHeld.m_41619_() && slot.m_5857_(stackHeld)) {
                    slot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
                }
            } else if (stackHeld.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else if (slot.m_5857_(stackHeld)) {
                if (ItemStack.m_41746_((ItemStack)stackSlot, (ItemStack)stackHeld)) {
                    stackSlot.m_41769_(amount);
                } else {
                    slot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
                }
            }
            if (stackSlot.m_41613_() > slot.m_6641_()) {
                stackSlot.m_41764_(slot.m_6641_());
            }
        } else if (dragType == 5) {
            ItemStack stackHeld = this.m_142621_();
            int amount = Math.min(slot.m_6641_(), stackHeld.m_41613_());
            if (!slot.m_6657_()) {
                slot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
            }
        }
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int slot) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slotObject = (Slot)this.f_38839_.get(slot);
        if (slotObject != null && slotObject.m_6657_()) {
            ItemStack itemstack1 = slotObject.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slot < this.slotCount ? !this.m_38903_(itemstack1, this.slotCount, this.f_38839_.size(), true) : !this.moveItemStackToWithMayPlace(itemstack1, 0, this.slotCount)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slotObject.m_5852_(ItemStack.f_41583_);
            } else {
                slotObject.m_6654_();
            }
        }
        return itemstack;
    }

    protected boolean moveItemStackToWithMayPlace(ItemStack pStack, int pStartIndex, int pEndIndex) {
        boolean inAllowedRange = true;
        int allowedStart = pStartIndex;
        for (int i = pStartIndex; i < pEndIndex; ++i) {
            boolean mayplace = ((Slot)this.f_38839_.get(i)).m_5857_(pStack);
            if (inAllowedRange && !mayplace) {
                if (this.m_38903_(pStack, allowedStart, i, false)) {
                    return true;
                }
                inAllowedRange = false;
                continue;
            }
            if (inAllowedRange || !mayplace) continue;
            allowedStart = i;
            inAllowedRange = true;
        }
        return inAllowedRange && this.m_38903_(pStack, allowedStart, pEndIndex, false);
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (this.inv != null) {
            this.inv.m_5785_(playerIn);
        }
    }

    public void receiveMessageFromScreen(CompoundTag nbt) {
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open ev) {
        AbstractContainerMenu abstractContainerMenu = ev.getContainer();
        if (abstractContainerMenu instanceof IEBaseContainer) {
            IEBaseContainer ieContainer = (IEBaseContainer)abstractContainerMenu;
            abstractContainerMenu = ev.getPlayer();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                ieContainer.usingPlayers.add(serverPlayer);
                ArrayList list = new ArrayList();
                for (int i = 0; i < ieContainer.genericData.size(); ++i) {
                    list.add(Pair.of((Object)i, ieContainer.genericData.get(i).dataPair()));
                }
                ImmersiveEngineering.packetHandler.sendTo((Object)new MessageContainerData(list), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @SubscribeEvent
    public static void onContainerClosed(PlayerContainerEvent.Close ev) {
        AbstractContainerMenu abstractContainerMenu = ev.getContainer();
        if (abstractContainerMenu instanceof IEBaseContainer) {
            IEBaseContainer ieContainer = (IEBaseContainer)abstractContainerMenu;
            abstractContainerMenu = ev.getPlayer();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                ieContainer.usingPlayers.remove(serverPlayer);
            }
        }
    }
}

