/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.entities.machines;

import com.google.common.collect.Lists;
import com.vies.viescraftmachines.util.enums.MachineType;
import com.vies.viescraftmachines.util.init.client.InitKeyBindingsVCM;
import com.vies.viescraftmachines.util.init.common.InitItemsVCM;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityMountable
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(EntityMountable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(EntityMountable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(EntityMountable.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float invFriction;
    private float outOfControlTicks;
    protected float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    protected boolean inputLeft;
    protected boolean inputRight;
    protected boolean inputForward;
    protected boolean inputBackward;
    protected boolean inputUp;
    protected boolean inputDown;
    protected boolean inputMachineMenu;
    protected boolean inputSpecialAction;
    protected boolean inputActivateTurbo;
    private double waterLevel;
    private double lavaLevel;
    private float landFriction;
    protected Status status;
    protected Status oldStatus;
    private double lastYd;

    public EntityMountable(EntityType<? extends EntityMountable> entitytypeIn, Level levelIn) {
        super(entitytypeIn, levelIn);
        this.f_19850_ = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void m_7380_(CompoundTag tagIn) {
    }

    protected void m_7378_(CompoundTag tagIn) {
    }

    public void m_8119_() {
        this.oldStatus = this.status;
        this.status = this.getStatus();
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.m_8119_();
        this.f_19853_.m_46473_().m_6180_("entityBaseTick");
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        if (this.f_19851_ > 0) {
            --this.f_19851_;
        }
        this.m_20157_();
        if (this.m_5843_()) {
            this.m_20076_();
        }
        if (this.f_19853_.f_46443_) {
            this.m_20095_();
        }
        this.m_146871_();
        this.f_19803_ = false;
        this.f_19853_.m_46473_().m_7238_();
        this.tickLerp();
        this.floatMachine();
        if (this.m_6109_()) {
            if (this.f_19853_.f_46443_ && this.m_6688_() instanceof Player) {
                this.applyPlayerInput();
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        this.m_20101_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.f_19853_.f_46443_ && !(this.m_6688_() instanceof Player);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.m_20363_((Entity)this)) continue;
                if (flag && this.m_20197_().size() < 2 && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
    }

    public boolean m_7337_(Entity entityIn) {
        return true;
    }

    public static boolean canVehicleCollide(Entity machineIn, Entity entityIn) {
        return (entityIn.m_5829_() || entityIn.m_6094_()) && !machineIn.m_20365_(machineIn);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected Vec3 m_7643_(Direction.Axis axisIn, BlockUtil.FoundRectangle foundRectangleIn) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(axisIn, foundRectangleIn));
    }

    public boolean m_6469_(DamageSource damageSourceIn, float valueIn) {
        if (this.m_6673_(damageSourceIn)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.m_5834_();
            this.m_146852_(GameEvent.f_157808_, damageSourceIn.m_7639_());
            return true;
        }
        return true;
    }

    public void setDamage(float valueIn) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(valueIn));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)valueIn);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setHurtDir(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)valueIn);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public void m_6053_() {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public InteractionResult m_6096_(Player playerIn, InteractionHand interactionhandIn) {
        return InteractionResult.SUCCESS;
    }

    protected void m_7840_(double yDistanceIn, boolean onGroundIn, BlockState p_38309_, BlockPos p_38310_) {
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    public Item getDropItem() {
        return (Item)InitItemsVCM.ADMINTOOL_COMPLETE_MACHINE_FLYING.get();
    }

    public boolean m_6087_() {
        return !this.m_146910_();
    }

    public void m_6453_(double xIn, double yIn, double zIn, float yRotateIn, float xRotateIn, int p_38304_, boolean p_38305_) {
        this.lerpX = xIn;
        this.lerpY = yIn;
        this.lerpZ = zIn;
        this.lerpYRot = yRotateIn;
        this.lerpXRot = xRotateIn;
        this.lerpSteps = 10;
    }

    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_20167_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    protected void floatMachine() {
        double d0 = -0.04f;
        double d1 = -0.04f;
        if (this.m_20068_()) {
            d1 = 0.0;
        }
        double d2 = 0.0;
        this.invFriction = 0.05f;
        if (this.oldStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.waterLevel = this.m_20227_(1.0);
            this.lavaLevel = this.m_20227_(1.0);
            this.m_6034_(this.m_20185_(), (double)(this.getWaterLevelAbove() - this.m_20206_()) + 0.101, this.m_20189_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            if (this.status == Status.IN_WATER) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                this.invFriction = this.setInvFrictionInWater();
            } else if (this.status == Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.invFriction = this.setInvFrictionUnderFlowingWater();
            } else if (this.status == Status.UNDER_WATER) {
                d1 = 0.04f;
                d2 = 0.01f;
                this.invFriction = this.setInvFrictionUnderWater();
            } else if (this.status == Status.IN_LAVA) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                this.invFriction = this.setInvFrictionInLava();
            } else if (this.status == Status.UNDER_FLOWING_LAVA) {
                d1 = -7.0E-4;
                this.invFriction = this.setInvFrictionUnderFlowingLava();
            } else if (this.status == Status.UNDER_LAVA) {
                d1 = 0.04f;
                d2 = 0.01f;
                this.invFriction = this.setInvFrictionUnderLava();
            } else if (this.status == Status.IN_AIR) {
                this.invFriction = this.setInvFrictionInAir();
            } else if (this.status == Status.ON_LAND) {
                if (this.getStatusPowered() || this.getStatusBroken()) {
                    this.invFriction = this.setInvFrictionOnGround();
                } else {
                    this.invFriction = this.landFriction;
                    if (this.m_6688_() instanceof Player) {
                        this.landFriction /= 2.0f;
                    }
                }
            }
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_ * (double)this.invFriction, vec3.f_82480_ * (double)this.invFriction + d1, vec3.f_82481_ * (double)this.invFriction);
            this.deltaRotation *= this.invFriction;
            if (d2 > 0.0) {
                Vec3 vec31 = this.m_20184_();
                this.m_20334_(vec31.f_82479_, (vec31.f_82480_ + d2 * 0.06153846016296973) * 0.75, vec31.f_82481_);
            }
        }
    }

    protected void m_5625_(float pVolume) {
    }

    public Status getStatus() {
        Status machine$status = this.isUnderwater();
        if (machine$status != null) {
            this.waterLevel = this.m_142469_().f_82292_;
            this.lavaLevel = this.m_142469_().f_82292_;
            return machine$status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        if (this.checkInLava()) {
            return Status.IN_LAVA;
        }
        if (this.isUnderLava()) {
            return Status.UNDER_LAVA;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            this.landFriction = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AABB aabb = this.m_142469_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)(aabb.f_82292_ - this.lastYd));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (fluidstate.m_205070_(FluidTags.f_13131_) || fluidstate.m_205070_(FluidTags.f_13132_)) {
                        f = Math.max(f, fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutableblockpos.m_123342_() + f;
        }
        return l + 1;
    }

    public float getGroundFriction() {
        AABB aabb = this.m_142469_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_((double)aabb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)aabb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)aabb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutableblockpos.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.f_19853_, (BlockPos)blockpos$mutableblockpos, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean checkInWater() {
        AABB aabb = this.m_142469_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status isUnderwater() {
        AABB aabb = this.m_142469_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private boolean checkInLava() {
        AABB aabb = this.m_142469_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.lavaLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13132_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos);
                    this.lavaLevel = Math.max((double)f, this.lavaLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status isUnderlava() {
        AABB aabb = this.m_142469_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13132_) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Status.UNDER_FLOWING_LAVA;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_LAVA : null;
    }

    public boolean m_5842_() {
        return this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_WATER;
    }

    public boolean isUnderLava() {
        return this.status == Status.UNDER_LAVA || this.status == Status.UNDER_FLOWING_LAVA;
    }

    public void setInput(boolean inputleftIn, boolean inputrightIn, boolean inputforwardIn, boolean inputbackwardIn, boolean inputupIn, boolean inputdownIn, boolean inputmachinemenuIn, boolean inputspecialactionIn, boolean inputactivateturboIn) {
        this.inputLeft = inputleftIn;
        this.inputRight = inputrightIn;
        this.inputForward = inputforwardIn;
        this.inputBackward = inputbackwardIn;
        this.inputUp = inputupIn;
        this.inputDown = inputdownIn;
        this.inputMachineMenu = inputmachinemenuIn;
        this.inputSpecialAction = inputspecialactionIn;
        this.inputActivateTurbo = inputactivateturboIn;
    }

    protected void controlMachine() {
    }

    protected void applyPlayerInput() {
        this.inputLeft = InitKeyBindingsVCM.keyTurnLeftVCM.m_90857_();
        this.inputRight = InitKeyBindingsVCM.keyTurnRightVCM.m_90857_();
        this.inputForward = InitKeyBindingsVCM.keyMoveForwardVCM.m_90857_();
        this.inputBackward = InitKeyBindingsVCM.keyMoveBackwardVCM.m_90857_();
        this.inputUp = InitKeyBindingsVCM.keyMoveUpVCM.m_90857_();
        this.inputDown = InitKeyBindingsVCM.keyMoveDownVCM.m_90857_();
        this.inputMachineMenu = InitKeyBindingsVCM.keyOpenMachineGUIVCM.m_90857_();
        this.inputSpecialAction = InitKeyBindingsVCM.keyMachineSpecialActionVCM.m_90857_();
        this.inputActivateTurbo = InitKeyBindingsVCM.keyMachineActivateTurboVCM.m_90857_();
        this.setInput(this.inputLeft, this.inputRight, this.inputForward, this.inputBackward, this.inputUp, this.inputDown, this.inputMachineMenu, this.inputSpecialAction, this.inputActivateTurbo);
    }

    public void m_7332_(Entity entityIn) {
        if (this.m_20363_(entityIn)) {
            float f = 0.0f;
            float f1 = (float)((this.m_146910_() ? (double)0.01f : this.m_6048_()) + entityIn.m_6049_());
            if (this.m_20197_().size() > 0) {
                int i = this.m_20197_().indexOf(entityIn);
                f = i == 0 ? 0.2f : -0.6f;
                if (entityIn instanceof Animal) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vec3 vec3 = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            entityIn.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3.f_82481_);
            entityIn.m_146922_(entityIn.m_146908_() + this.deltaRotation);
            entityIn.m_5616_(entityIn.m_6080_() + this.deltaRotation);
            this.clampRotation(entityIn);
            if (entityIn instanceof Animal && this.m_20197_().size() > 1) {
                int j = entityIn.m_142049_() % 2 == 0 ? 90 : 270;
                entityIn.m_5618_(((Animal)entityIn).f_20883_ + (float)j);
                entityIn.m_5616_(entityIn.m_6080_() + (float)j);
            }
        }
    }

    public Vec3 m_7688_(LivingEntity ridingEntityIn) {
        double d1;
        Vec3 vec3 = EntityMountable.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)ridingEntityIn.m_20205_(), (float)ridingEntityIn.m_146908_());
        double d0 = this.m_20185_() + vec3.f_82479_;
        BlockPos blockpos = new BlockPos(d0, this.m_142469_().f_82292_, d1 = this.m_20189_() + vec3.f_82481_);
        BlockPos blockpos1 = blockpos.m_7495_();
        if (!this.f_19853_.m_46801_(blockpos1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.f_19853_.m_45573_(blockpos);
            if (DismountHelper.m_38439_((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.m_123342_() + d2, d1));
            }
            if (DismountHelper.m_38439_((double)(d3 = this.f_19853_.m_45573_(blockpos1)))) {
                list.add(new Vec3(d0, (double)blockpos1.m_123342_() + d3, d1));
            }
            for (Pose pose : ridingEntityIn.m_7431_()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.f_19853_, (Vec3)vec31, (LivingEntity)ridingEntityIn, (Pose)pose)) continue;
                    ridingEntityIn.m_20124_(pose);
                    return vec31;
                }
            }
        }
        return super.m_7688_(ridingEntityIn);
    }

    public double m_6048_() {
        return 0.5;
    }

    protected void clampRotation(Entity entityIn) {
        entityIn.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityIn.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entityIn.f_19859_ += f1 - f;
        entityIn.m_146922_(entityIn.m_146908_() + f1 - f);
        entityIn.m_5616_(entityIn.m_146908_());
    }

    public void m_7340_(Entity entityIn) {
        this.clampRotation(entityIn);
    }

    protected boolean m_7310_(Entity entityIn) {
        return this.m_20197_().size() < 2;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    protected void m_20348_(Entity passengerIn) {
        super.m_20348_(passengerIn);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
    }

    public MachineType getMachineType() {
        return MachineType.NONE;
    }

    protected float setInvFrictionOnGround() {
        return 0.5f;
    }

    protected float setInvFrictionInAir() {
        return 0.5f;
    }

    protected float setInvFrictionInWater() {
        return 0.45f;
    }

    protected float setInvFrictionUnderWater() {
        return 0.45f;
    }

    protected float setInvFrictionUnderFlowingWater() {
        return 0.9f;
    }

    protected float setInvFrictionInLava() {
        return 0.9f;
    }

    protected float setInvFrictionUnderLava() {
        return 0.45f;
    }

    protected float setInvFrictionUnderFlowingLava() {
        return 0.9f;
    }

    public void setStatusBroken(boolean valueIn) {
    }

    public boolean getStatusBroken() {
        return false;
    }

    public void setStatusPowered(boolean valueIn) {
    }

    public boolean getStatusPowered() {
        return false;
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        IN_LAVA,
        UNDER_LAVA,
        UNDER_FLOWING_LAVA,
        ON_LAND,
        IN_AIR;

    }
}

