/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.client.render.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.vies.viescraftmachines.client.model.chassis.ModelChassisFrame;
import com.vies.viescraftmachines.client.model.chassis.ModelChassisType;
import com.vies.viescraftmachines.common.entities.thrown.EntityChassisBase;
import com.vies.viescraftmachines.common.entities.thrown.EntityChassisTypeFlying;
import com.vies.viescraftmachines.util.init.client.InitModelLayerVCM;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class RendererChassisTypeFlying<T extends EntityChassisTypeFlying>
extends EntityRenderer<T> {
    private final ModelChassisFrame<EntityChassisTypeFlying> modelChassisFrame;
    private final ModelChassisType<EntityChassisTypeFlying> modelChassisType;
    private static final ResourceLocation CHASSIS_TEXTURE_LOCATION_FRAME = new ResourceLocation("viescraftmachines", "textures/entities/chassis/chassis-frame.png");
    private static final ResourceLocation CHASSIS_TEXTURE_LOCATION_TYPE = new ResourceLocation("viescraftmachines", "textures/entities/chassis/chassis-type-flying.png");
    private final ItemRenderer itemRenderer;

    public RendererChassisTypeFlying(EntityRendererProvider.Context contextIn) {
        super(contextIn);
        this.f_114477_ = 0.0f;
        this.itemRenderer = contextIn.m_174025_();
        this.modelChassisFrame = new ModelChassisFrame(contextIn.m_174023_(InitModelLayerVCM.MODEL_CHASSIS_FRAME));
        this.modelChassisType = new ModelChassisType(contextIn.m_174023_(InitModelLayerVCM.MODEL_CHASSIS_TYPE));
    }

    public void render(T entityIn, float entityYawIn, float particleTicksIn, PoseStack poseStackIn, MultiBufferSource bufferIn, int lightIn) {
        super.m_7392_(entityIn, entityYawIn, particleTicksIn, poseStackIn, bufferIn, lightIn);
        poseStackIn.m_85836_();
        poseStackIn.m_85837_(0.0, 1.5, 0.0);
        poseStackIn.m_85845_(Vector3f.f_122225_.m_122240_(90.0f - entityYawIn));
        poseStackIn.m_85841_(1.0f, -1.0f, -1.0f);
        GlStateManager.m_84525_();
        GlStateManager.m_84328_((int)770, (int)771);
        GlStateManager.m_84091_();
        GlStateManager.m_84318_((float)0.2f, (float)0.4f, (float)0.1f, (float)1.0f);
        this.modelChassisFrame.m_6973_((EntityChassisTypeFlying)((Object)entityIn), 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumerFrame = bufferIn.m_6299_(this.modelChassisFrame.m_103119_(this.getTextureLocationFrame(entityIn)));
        this.modelChassisFrame.m_7695_(poseStackIn, vertexconsumerFrame, lightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.modelChassisType.m_6973_((EntityChassisTypeFlying)((Object)entityIn), 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumerType = bufferIn.m_6299_(this.modelChassisType.m_103119_(this.getTextureLocationType(entityIn)));
        this.modelChassisType.m_7695_(poseStackIn, vertexconsumerFrame, lightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStackIn.m_85849_();
        RenderNameplateEvent renderNameplateEvent1 = new RenderNameplateEvent(entityIn, entityIn.m_5446_(), (EntityRenderer)this, poseStackIn, bufferIn, lightIn, particleTicksIn);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent1);
        if (renderNameplateEvent1.getResult() != Event.Result.DENY && (renderNameplateEvent1.getResult() == Event.Result.ALLOW || this.shouldShowName(entityIn)) && entityIn instanceof EntityChassisTypeFlying) {
            T chassis = entityIn;
            if (!((EntityChassisBase)((Object)chassis)).getStatusKitCloth()) {
                this.renderInformationTag1(entityIn, (Component)new TranslatableComponent("renderer.viescraftmachines.overhead.3").m_130940_(ChatFormatting.RED), poseStackIn, bufferIn, lightIn);
                poseStackIn.m_85837_(0.0, 0.25, 0.0);
            }
            if (!((EntityChassisBase)((Object)chassis)).getStatusKitMetal()) {
                this.renderInformationTag1(entityIn, (Component)new TranslatableComponent("renderer.viescraftmachines.overhead.2").m_130940_(ChatFormatting.RED), poseStackIn, bufferIn, lightIn);
                poseStackIn.m_85837_(0.0, 0.25, 0.0);
            }
            if (!((EntityChassisBase)((Object)chassis)).getStatusKitPanel()) {
                this.renderInformationTag1(entityIn, (Component)new TranslatableComponent("renderer.viescraftmachines.overhead.1").m_130940_(ChatFormatting.RED), poseStackIn, bufferIn, lightIn);
                poseStackIn.m_85837_(0.0, 0.25, 0.0);
            }
            if (((EntityChassisBase)((Object)chassis)).getStatusKitPanel() && ((EntityChassisBase)((Object)chassis)).getStatusKitMetal() && ((EntityChassisBase)((Object)chassis)).getStatusKitCloth()) {
                this.renderInformationTag1(entityIn, (Component)new TranslatableComponent("renderer.viescraftmachines.overhead.4").m_130940_(ChatFormatting.GREEN), poseStackIn, bufferIn, lightIn);
                poseStackIn.m_85837_(0.0, 0.75, 0.0);
            }
        }
    }

    public ResourceLocation getTextureLocation(T resourceLocation) {
        return CHASSIS_TEXTURE_LOCATION_FRAME;
    }

    public ResourceLocation getTextureLocationFrame(T resourceLocation) {
        return CHASSIS_TEXTURE_LOCATION_FRAME;
    }

    public ResourceLocation getTextureLocationType(T resourceLocation) {
        return CHASSIS_TEXTURE_LOCATION_TYPE;
    }

    public boolean shouldRender(T p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        return true;
    }

    protected boolean shouldShowName(T pEntity) {
        return true;
    }

    protected void renderNameTag(T pEntity, Component pDisplayName, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
    }

    protected void renderInformationTag1(T pEntity, Component pDisplayName, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        double d0 = this.f_114476_.m_114471_(pEntity);
        if (ForgeHooksClient.isNameplateInRenderDistance(pEntity, (double)d0)) {
            boolean flag = !pEntity.m_20163_();
            float f = pEntity.m_20206_() + 0.5f;
            int i = "deadmau5".equals(pDisplayName.getString()) ? -10 : 0;
            pMatrixStack.m_85836_();
            pMatrixStack.m_85837_(0.0, (double)f, 0.0);
            pMatrixStack.m_85845_(this.f_114476_.m_114470_());
            pMatrixStack.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = pMatrixStack.m_85850_().m_85861_();
            float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            Font font = this.m_114481_();
            float f2 = -font.m_92852_((FormattedText)pDisplayName) / 2;
            font.m_92841_(pDisplayName, f2, (float)i, 0x20FFFFFF, false, matrix4f, pBuffer, flag, j, pPackedLight);
            if (flag) {
                font.m_92841_(pDisplayName, f2, (float)i, -1, false, matrix4f, pBuffer, false, 0, pPackedLight);
            }
            pMatrixStack.m_85849_();
        }
    }
}

