/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.ConfiguredHelper;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.util.OptiFineHelper;
import com.mrcrayfish.configured.impl.ForgeConfig;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.gui.ModListScreen;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod.EventBusSubscriber(modid="configured", value={Dist.CLIENT})
public class ClientHandler {
    public static final KeyMapping KEY_OPEN_MOD_LIST = new KeyMapping("key.configured.open_mod_list", -1, "key.categories.configured");

    public static void registerKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyMapping)KEY_OPEN_MOD_LIST);
    }

    public static void generateConfigFactories() {
        Configured.LOGGER.info("Creating config GUI factories...");
        ModList.get().forEachModContainer((modId, container) -> {
            if (container.getCustomExtension(ConfigGuiHandler.ConfigGuiFactory.class).isPresent() && !((Boolean)Config.CLIENT.forceConfiguredMenu.get()).booleanValue()) {
                return;
            }
            Map<ModConfig.Type, Set<IModConfig>> modConfigMap = ClientHandler.createConfigMap(container);
            if (!modConfigMap.isEmpty()) {
                Configured.LOGGER.info("Registering config factory for mod {}. Found {} client config(s) and {} common config(s)", modId, (Object)modConfigMap.getOrDefault(ModConfig.Type.CLIENT, Collections.emptySet()).size(), (Object)modConfigMap.getOrDefault(ModConfig.Type.COMMON, Collections.emptySet()).size());
                String displayName = container.getModInfo().getDisplayName();
                ResourceLocation backgroundTexture = ClientHandler.getBackgroundTexture(container.getModInfo());
                container.registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, screen) -> ConfiguredHelper.createSelectionScreen(screen, (Component)new TextComponent(displayName), modConfigMap, backgroundTexture)));
            }
        });
    }

    private static EnumMap<ModConfig.Type, Set<ModConfig>> getConfigSets() {
        return (EnumMap)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"configSets");
    }

    public static Map<ModConfig.Type, Set<IModConfig>> createConfigMap(ModContainer container) {
        HashMap<ModConfig.Type, Set<IModConfig>> modConfigMap = new HashMap<ModConfig.Type, Set<IModConfig>>();
        ClientHandler.addConfigSetToMap(container, ModConfig.Type.CLIENT, modConfigMap);
        ClientHandler.addConfigSetToMap(container, ModConfig.Type.COMMON, modConfigMap);
        ClientHandler.addConfigSetToMap(container, ModConfig.Type.SERVER, modConfigMap);
        return modConfigMap;
    }

    private static void addConfigSetToMap(ModContainer container, ModConfig.Type type, Map<ModConfig.Type, Set<IModConfig>> configMap) {
        if (type == ModConfig.Type.CLIENT && OptiFineHelper.isLoaded() && container.getModId().equals("forge")) {
            Configured.LOGGER.info("Ignoring Forge's client config since OptiFine was detected");
            return;
        }
        Set<ModConfig> configSet = ClientHandler.getConfigSets().get(type);
        Set filteredConfigSets = configSet.stream().filter(config -> config.getModId().equals(container.getModId())).map(ForgeConfig::new).collect(Collectors.toSet());
        if (!filteredConfigSets.isEmpty()) {
            configMap.put(type, filteredConfigSets);
        }
    }

    private static ResourceLocation getBackgroundTexture(IModInfo info) {
        Optional optional;
        String configBackground = (String)info.getModProperties().get("configuredBackground");
        if (configBackground != null) {
            return new ResourceLocation(configBackground);
        }
        if (info instanceof ModInfo && (optional = ((ModInfo)info).getConfigElement(new String[]{"configBackground"})).isPresent()) {
            return new ResourceLocation((String)optional.get());
        }
        return Screen.f_93096_;
    }

    public static void updateAbstractListTexture(AbstractSelectionList<?> list) {
        if (list instanceof IBackgroundTexture) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)((IBackgroundTexture)list).getBackgroundTexture());
        }
    }

    public static void updateScreenTexture(Screen screen) {
        if (screen instanceof IBackgroundTexture) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)((IBackgroundTexture)screen).getBackgroundTexture());
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.KeyInputEvent event) {
        if (event.getAction() == 1 && KEY_OPEN_MOD_LIST.m_90857_()) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null) {
                return;
            }
            Screen oldScreen = minecraft.f_91080_;
            minecraft.m_91152_((Screen)new ModListScreen(oldScreen));
        }
    }
}

