/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;

public class Pipe
extends Container
implements IPole {
    public static final VoxelShape SHAPE = Shapes.m_83048_((double)0.4, (double)0.0, (double)0.4, (double)0.6, (double)1.0, (double)0.6);
    public static ForgeConfigSpec.ConfigValue<Integer> maxPipesAtOnce;

    public Pipe(Container.Properties<?> props) {
        super(props);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.canStayAt(level, pos);
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.PIPE;
    }

    public boolean isActive(BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean isApex(BlockState state) {
        return GameWorld.SmokeContainers.suctionHoppers.containsKey((Object)state);
    }

    public boolean isPole(BlockState state) {
        return state.m_60734_() instanceof IPole;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int quantity = player.m_21206_().m_41720_() == player.m_21205_().m_41720_() ? (Integer)maxPipesAtOnce.get() : 1;
        return this.buildBy(player, level, pos, hand, hit, quantity);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int quantity = player.m_6047_() ? (Integer)maxPipesAtOnce.get() : 1;
            this.breakBy(player, server, pos, quantity);
        }
        return false;
    }
}

