/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.linked;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.IRedstoneLinkable;
import com.simibubi.create.content.logistics.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.Couple;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class LinkBehaviour
extends TileEntityBehaviour
implements IRedstoneLinkable {
    public static final BehaviourType<LinkBehaviour> TYPE = new BehaviourType();
    RedstoneLinkNetworkHandler.Frequency frequencyFirst = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    RedstoneLinkNetworkHandler.Frequency frequencyLast = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    ValueBoxTransform firstSlot;
    ValueBoxTransform secondSlot;
    Vec3 textShift;
    public boolean newPosition;
    private Mode mode;
    private IntSupplier transmission;
    private IntConsumer signalCallback;

    protected LinkBehaviour(SmartTileEntity te, Pair<ValueBoxTransform, ValueBoxTransform> slots) {
        super(te);
        this.firstSlot = (ValueBoxTransform)slots.getLeft();
        this.secondSlot = (ValueBoxTransform)slots.getRight();
        this.textShift = Vec3.f_82478_;
        this.newPosition = true;
    }

    public static LinkBehaviour receiver(SmartTileEntity te, Pair<ValueBoxTransform, ValueBoxTransform> slots, IntConsumer signalCallback) {
        LinkBehaviour behaviour = new LinkBehaviour(te, slots);
        behaviour.signalCallback = signalCallback;
        behaviour.mode = Mode.RECEIVE;
        return behaviour;
    }

    public static LinkBehaviour transmitter(SmartTileEntity te, Pair<ValueBoxTransform, ValueBoxTransform> slots, IntSupplier transmission) {
        LinkBehaviour behaviour = new LinkBehaviour(te, slots);
        behaviour.transmission = transmission;
        behaviour.mode = Mode.TRANSMIT;
        return behaviour;
    }

    public LinkBehaviour moveText(Vec3 shift) {
        this.textShift = shift;
        return this;
    }

    public void copyItemsFrom(LinkBehaviour behaviour) {
        if (behaviour == null) {
            return;
        }
        this.frequencyFirst = behaviour.frequencyFirst;
        this.frequencyLast = behaviour.frequencyLast;
    }

    @Override
    public boolean isListening() {
        return this.mode == Mode.RECEIVE;
    }

    @Override
    public int getTransmittedStrength() {
        return this.mode == Mode.TRANSMIT ? this.transmission.getAsInt() : 0;
    }

    @Override
    public void setReceivedStrength(int networkPower) {
        if (!this.newPosition) {
            return;
        }
        this.signalCallback.accept(networkPower);
    }

    public void notifySignalChange() {
        Create.REDSTONE_LINK_NETWORK_HANDLER.updateNetworkOf((LevelAccessor)this.getWorld(), this);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getWorld().f_46443_) {
            return;
        }
        this.getHandler().addToNetwork((LevelAccessor)this.getWorld(), this);
        this.newPosition = true;
    }

    @Override
    public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
        return Couple.create(this.frequencyFirst, this.frequencyLast);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.getWorld().f_46443_) {
            return;
        }
        this.getHandler().removeFromNetwork((LevelAccessor)this.getWorld(), this);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.m_128365_("FrequencyFirst", (Tag)this.frequencyFirst.getStack().m_41739_(new CompoundTag()));
        nbt.m_128365_("FrequencyLast", (Tag)this.frequencyLast.getStack().m_41739_(new CompoundTag()));
        nbt.m_128356_("LastKnownPosition", this.tileEntity.m_58899_().m_121878_());
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        long positionKey;
        long positionInTag = this.tileEntity.m_58899_().m_121878_();
        this.newPosition = positionInTag != (positionKey = nbt.m_128454_("LastKnownPosition"));
        super.read(nbt, clientPacket);
        this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("FrequencyFirst")));
        this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("FrequencyLast")));
    }

    public void setFrequency(boolean first, ItemStack stack) {
        boolean changed;
        stack = stack.m_41777_();
        stack.m_41764_(1);
        ItemStack toCompare = first ? this.frequencyFirst.getStack() : this.frequencyLast.getStack();
        boolean bl = changed = !ItemStack.m_41746_((ItemStack)stack, (ItemStack)toCompare) || !ItemStack.m_41658_((ItemStack)stack, (ItemStack)toCompare);
        if (changed) {
            this.getHandler().removeFromNetwork((LevelAccessor)this.getWorld(), this);
        }
        if (first) {
            this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of(stack);
        } else {
            this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of(stack);
        }
        if (!changed) {
            return;
        }
        this.tileEntity.sendData();
        this.getHandler().addToNetwork((LevelAccessor)this.getWorld(), this);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    private RedstoneLinkNetworkHandler getHandler() {
        return Create.REDSTONE_LINK_NETWORK_HANDLER;
    }

    public boolean testHit(Boolean first, Vec3 hit) {
        BlockState state = this.tileEntity.m_58900_();
        Vec3 localHit = hit.m_82546_(Vec3.m_82528_((Vec3i)this.tileEntity.m_58899_()));
        return (first != false ? this.firstSlot : this.secondSlot).testHit(state, localHit);
    }

    @Override
    public boolean isAlive() {
        return !this.tileEntity.m_58901_() && this.getWorld().m_7702_(this.getPos()) == this.tileEntity;
    }

    @Override
    public BlockPos getLocation() {
        return this.getPos();
    }

    static enum Mode {
        TRANSMIT,
        RECEIVE;

    }

    public static class SlotPositioning {
        Function<BlockState, Pair<Vec3, Vec3>> offsets;
        Function<BlockState, Vec3> rotation;
        float scale;

        public SlotPositioning(Function<BlockState, Pair<Vec3, Vec3>> offsetsForState, Function<BlockState, Vec3> rotationForState) {
            this.offsets = offsetsForState;
            this.rotation = rotationForState;
            this.scale = 1.0f;
        }

        public SlotPositioning scale(float scale) {
            this.scale = scale;
            return this;
        }
    }
}

