/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.schedule;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ScheduleItemRetrieval {
    @SubscribeEvent
    public static void removeScheduleFromConductor(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        Player player = event.getPlayer();
        if (player == null || entity == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        Entity rootVehicle = entity.m_20201_();
        if (!(rootVehicle instanceof CarriageContraptionEntity)) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (AllItems.SCHEDULE.isIn(itemStack) && entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            itemStack.m_41720_().m_6880_(itemStack, player, (LivingEntity)wolf, event.getHand());
            return;
        }
        if (player.f_19853_.f_46443_) {
            return;
        }
        if (event.getHand() == InteractionHand.OFF_HAND) {
            return;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)rootVehicle;
        Contraption contraption = cce.getContraption();
        if (!(contraption instanceof CarriageContraption)) {
            return;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        Train train = cce.getCarriage().train;
        if (train == null) {
            return;
        }
        if (train.runtime.getSchedule() == null) {
            return;
        }
        Integer seatIndex = contraption.getSeatMapping().get(entity.m_142081_());
        if (seatIndex == null) {
            return;
        }
        BlockPos seatPos = contraption.getSeats().get(seatIndex);
        Couple<Boolean> directions = cc.conductorSeats.get(seatPos);
        if (directions == null) {
            return;
        }
        if (train.runtime.paused && !train.runtime.completed) {
            train.runtime.paused = false;
            AllSoundEvents.CONFIRM.playOnServer(player.f_19853_, (Vec3i)player.m_142538_(), 1.0f, 1.0f);
            player.m_5661_((Component)Lang.translateDirect("schedule.continued", new Object[0]), true);
            event.setCanceled(true);
            return;
        }
        ItemStack itemInHand = player.m_21120_(event.getHand());
        if (!itemInHand.m_41619_()) {
            AllSoundEvents.DENY.playOnServer(player.f_19853_, (Vec3i)player.m_142538_(), 1.0f, 1.0f);
            player.m_5661_((Component)Lang.translateDirect("schedule.remove_with_empty_hand", new Object[0]), true);
            event.setCanceled(true);
            return;
        }
        AllSoundEvents.playItemPickup(player);
        player.m_5661_((Component)Lang.translateDirect(train.runtime.isAutoSchedule ? "schedule.auto_removed_from_train" : "schedule.removed_from_train", new Object[0]), true);
        player.m_150109_().m_150079_(train.runtime.returnSchedule());
        event.setCanceled(true);
    }
}

