/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.components.steam.whistle.WhistleBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ArrivalSoundQueue {
    public int offset;
    int min;
    int max;
    Multimap<Integer, BlockPos> sources = Multimaps.newMultimap(new HashMap(), ArrayList::new);

    public ArrivalSoundQueue() {
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
    }

    @Nullable
    public Integer firstTick() {
        return this.sources.isEmpty() ? null : Integer.valueOf(this.min + this.offset);
    }

    @Nullable
    public Integer lastTick() {
        return this.sources.isEmpty() ? null : Integer.valueOf(this.max + this.offset);
    }

    public boolean tick(CarriageContraptionEntity entity, int tick, boolean backwards) {
        if (!this.sources.containsKey((Object)(tick -= this.offset))) {
            return backwards ? tick > this.min : tick < this.max;
        }
        Contraption contraption = entity.getContraption();
        for (BlockPos blockPos : this.sources.get((Object)tick)) {
            ArrivalSoundQueue.play(entity, contraption.getBlocks().get(blockPos));
        }
        return backwards ? tick > this.min : tick < this.max;
    }

    public Pair<Boolean, Integer> getFirstWhistle(CarriageContraptionEntity entity) {
        Integer firstTick = this.firstTick();
        Integer lastTick = this.lastTick();
        if (firstTick == null || lastTick == null || firstTick > lastTick) {
            return null;
        }
        for (int i = firstTick.intValue(); i <= lastTick; ++i) {
            if (!this.sources.containsKey((Object)(i - this.offset))) continue;
            Contraption contraption = entity.getContraption();
            for (BlockPos blockPos : this.sources.get((Object)(i - this.offset))) {
                BlockState state;
                StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(blockPos);
                if (info == null || !((state = info.f_74676_).m_60734_() instanceof WhistleBlock) || info.f_74677_ == null) continue;
                int pitch = info.f_74677_.m_128451_("Pitch");
                WhistleBlock.WhistleSize size = (WhistleBlock.WhistleSize)((Object)state.m_61143_(WhistleBlock.SIZE));
                return Pair.of(size == WhistleBlock.WhistleSize.LARGE, (size == WhistleBlock.WhistleSize.SMALL ? 12 : 0) - pitch);
            }
        }
        return null;
    }

    public void serialize(CompoundTag tagIn) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Offset", this.offset);
        tag.m_128365_("Sources", (Tag)NBTHelper.writeCompoundList(this.sources.entries(), e -> {
            CompoundTag c = new CompoundTag();
            c.m_128405_("Tick", ((Integer)e.getKey()).intValue());
            c.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)e.getValue())));
            return c;
        }));
        tagIn.m_128365_("SoundQueue", (Tag)tag);
    }

    public void deserialize(CompoundTag tagIn) {
        CompoundTag tag = tagIn.m_128469_("SoundQueue");
        this.offset = tag.m_128451_("Offset");
        NBTHelper.iterateCompoundList(tag.m_128437_("Sources", 10), c -> this.add(c.m_128451_("Tick"), NbtUtils.m_129239_((CompoundTag)c.m_128469_("Pos"))));
    }

    public void add(int offset, BlockPos localPos) {
        this.sources.put((Object)offset, (Object)localPos);
        this.min = Math.min(offset, this.min);
        this.max = Math.max(offset, this.max);
    }

    public static boolean isPlayable(BlockState state) {
        if (state.m_60734_() instanceof BellBlock) {
            return true;
        }
        if (state.m_60734_() instanceof NoteBlock) {
            return true;
        }
        return state.m_60734_() instanceof WhistleBlock;
    }

    public static void play(CarriageContraptionEntity entity, StructureTemplate.StructureBlockInfo info) {
        Block block;
        if (info == null) {
            return;
        }
        BlockState state = info.f_74676_;
        if (state.m_60734_() instanceof BellBlock) {
            if (AllBlocks.HAUNTED_BELL.has(state)) {
                ArrivalSoundQueue.playSimple(entity, AllSoundEvents.HAUNTED_BELL_USE.getMainEvent(), 1.0f, 1.0f);
            } else {
                ArrivalSoundQueue.playSimple(entity, SoundEvents.f_11699_, 1.0f, 1.0f);
            }
        }
        if ((block = state.m_60734_()) instanceof NoteBlock) {
            NoteBlock nb = (NoteBlock)block;
            float f = (float)Math.pow(2.0, (double)((Integer)state.m_61143_((Property)NoteBlock.f_55013_) - 12) / 12.0);
            ArrivalSoundQueue.playSimple(entity, ((NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_)).m_61668_(), 1.0f, f);
        }
        if (state.m_60734_() instanceof WhistleBlock && info.f_74677_ != null) {
            int pitch = info.f_74677_.m_128451_("Pitch");
            WhistleBlock.WhistleSize size = (WhistleBlock.WhistleSize)((Object)state.m_61143_(WhistleBlock.SIZE));
            float f = (float)Math.pow(2.0, (double)((size == WhistleBlock.WhistleSize.SMALL ? 12 : 0) - pitch) / 12.0);
            ArrivalSoundQueue.playSimple(entity, (size == WhistleBlock.WhistleSize.LARGE ? AllSoundEvents.WHISTLE_TRAIN_LOW : AllSoundEvents.WHISTLE_TRAIN).getMainEvent(), 1.0f, f);
        }
    }

    private static void playSimple(CarriageContraptionEntity entity, SoundEvent event, float volume, float pitch) {
        entity.f_19853_.m_6269_(null, (Entity)entity, event, SoundSource.NEUTRAL, 5.0f * volume, pitch);
    }
}

