/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.goggles;

import com.simibubi.create.AllItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class GogglesItem
extends Item {
    private static final List<Predicate<Player>> IS_WEARING_PREDICATES = new ArrayList<Predicate<Player>>();

    public GogglesItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        EquipmentSlot equipmentslottype = Mob.m_147233_((ItemStack)itemstack);
        ItemStack itemstack1 = playerIn.m_6844_(equipmentslottype);
        if (itemstack1.m_41619_()) {
            playerIn.m_8061_(equipmentslottype, itemstack.m_41777_());
            itemstack.m_41764_(0);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
    }

    public static boolean isWearingGoggles(Player player) {
        for (Predicate<Player> predicate : IS_WEARING_PREDICATES) {
            if (!predicate.test(player)) continue;
            return true;
        }
        return false;
    }

    public static void addIsWearingPredicate(Predicate<Player> predicate) {
        IS_WEARING_PREDICATES.add(predicate);
    }

    static {
        GogglesItem.addIsWearingPredicate(player -> AllItems.GOGGLES.isIn(player.m_6844_(EquipmentSlot.HEAD)));
    }
}

