/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.core.collect.Table;

public final class ReflectionUtil {
    private final Table<Class<?>, Class<?>, List<Field>> cache = Table.hashBasedTable();

    public <T> Stream<T> getFieldWithClass(Object object, Class<? extends T> fieldClass) {
        return this.getFieldsCached(object, fieldClass).flatMap(field -> ReflectionUtil.getFieldValue(object, field, fieldClass).stream());
    }

    private static <T> Optional<T> getFieldValue(Object object, Field field, Class<? extends T> fieldClass) {
        Object fieldValue;
        try {
            fieldValue = field.get(object);
        }
        catch (IllegalAccessException ignored) {
            return Optional.empty();
        }
        if (fieldClass.isInstance(fieldValue)) {
            T cast = fieldClass.cast(fieldValue);
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    private Stream<Field> getFieldsCached(Object object, Class<?> fieldClass) {
        return this.cache.computeIfAbsent(fieldClass, object.getClass(), () -> this.getFieldUncached(object, fieldClass)).stream();
    }

    private List<Field> getFieldUncached(Object object, Class<?> fieldClass) {
        return this.allFields(object).filter(field -> fieldClass.isAssignableFrom(field.getType())).mapMulti((field, mapper) -> {
            try {
                field.setAccessible(true);
                mapper.accept(field);
            }
            catch (SecurityException | InaccessibleObjectException runtimeException) {
                // empty catch block
            }
        }).toList();
    }

    private Stream<Field> allFields(Object object) {
        Class<?> objectClass = object.getClass();
        ArrayList classes = new ArrayList();
        do {
            classes.add(objectClass);
        } while ((objectClass = objectClass.getSuperclass()) != Object.class);
        return classes.stream().flatMap(c -> {
            try {
                Field[] fields = c.getDeclaredFields();
                return Arrays.stream(fields);
            }
            catch (SecurityException ignored) {
                return Stream.of(new Field[0]);
            }
        });
    }
}

