/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.nio.IntBuffer;
import java.util.function.Supplier;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL30C;

public class RenderWrapper {
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_LINEAR = 9729;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_REPEAT = 10497;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_ZERO = 0;
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_GREATER = 516;
    public static final int GL_NEAREST = 9728;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GEQUAL = 518;
    public static final int GL_VIEWPORT = 2978;
    public static final int UNSIGNED_INT_8_8_8_8_REV = 33639;
    public static final int GL_BGRA = 32993;
    public static final int GL_RGBA = 6408;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public static final boolean errorCheck = JourneymapClient.getInstance().getCoreProperties().glErrorChecking.get();

    public static void setColor4f(float red, float green, float blue, float alpha) {
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
        RenderWrapper.checkGLError("setColor4f");
    }

    public static void clearColor(float red, float green, float blue, float alpha) {
        RenderSystem.m_69424_((float)red, (float)green, (float)blue, (float)alpha);
        RenderWrapper.checkGLError("clearColor");
    }

    public static void enableBlend() {
        RenderSystem.m_69478_();
        RenderWrapper.checkGLError("enableBlend");
    }

    public static void disableBlend() {
        RenderSystem.m_69461_();
        RenderWrapper.checkGLError("disableBlend");
    }

    public static void defaultBlendFunc() {
        RenderSystem.m_69453_();
        RenderWrapper.checkGLError("defaultBlendFunc");
    }

    public static void enableTexture() {
        RenderSystem.m_69493_();
        RenderWrapper.checkGLError("enableTexture");
    }

    public static void disableTexture() {
        RenderSystem.m_69472_();
        RenderWrapper.checkGLError("disableTexture");
    }

    public static void enableDepthTest() {
        RenderSystem.m_69482_();
        RenderWrapper.checkGLError("enableDepthTest");
    }

    public static void disableDepthTest() {
        RenderSystem.m_69465_();
        RenderWrapper.checkGLError("disableDepthTest");
    }

    public static Matrix4f getProjectionMatrix() {
        Matrix4f projectionMatrix = RenderSystem.m_157192_();
        RenderWrapper.checkGLError("getProjectionMatrix");
        return projectionMatrix;
    }

    public static void enableCull() {
        RenderSystem.m_69481_();
        RenderWrapper.checkGLError("enableCull");
    }

    public static void disableCull() {
        RenderSystem.m_69464_();
        RenderWrapper.checkGLError("disableCull");
    }

    public static int getError() {
        return GL11C.glGetError();
    }

    public static void depthMask(boolean flag) {
        RenderSystem.m_69458_((boolean)flag);
        RenderWrapper.checkGLError("depthMask");
    }

    public static void getIntegerv(int pname, IntBuffer params) {
        GL11C.glGetIntegerv((int)pname, (IntBuffer)params);
        RenderWrapper.checkGLError("getIntegerv");
    }

    public static void texParameter(int target, int pname, int param) {
        RenderSystem.m_69937_((int)target, (int)pname, (int)param);
        RenderWrapper.checkGLError("texParameter");
    }

    public static void blendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha) {
        RenderSystem.m_69411_((int)sfactorRGB, (int)dfactorRGB, (int)sfactorAlpha, (int)dfactorAlpha);
        RenderWrapper.checkGLError("blendFuncSeparate");
    }

    public static void blendFunc(int sfactor, int dfactor) {
        RenderSystem.m_69405_((int)sfactor, (int)dfactor);
        RenderWrapper.checkGLError("blendFunc");
    }

    public static void bindFramebuffer(int target, int framebuffer) {
        GL30C.glBindFramebuffer((int)target, (int)framebuffer);
        RenderWrapper.checkGLError("bindFramebuffer");
    }

    public static void blitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter2) {
        GlStateManager.m_84188_((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter2);
        RenderWrapper.checkGLError("blitFramebuffer");
    }

    public static void setShader(Supplier<ShaderInstance> shaderInstanceSupplier) {
        RenderSystem.m_157427_(shaderInstanceSupplier);
        RenderWrapper.checkGLError("setShader");
    }

    public static void setShaderTexture(int index, int id) {
        RenderSystem.m_157453_((int)index, (int)id);
        RenderWrapper.checkGLError("setShaderTexture");
    }

    public static void setShaderTexture(int index, ResourceLocation resourceLocation) {
        RenderSystem.m_157456_((int)index, (ResourceLocation)resourceLocation);
        RenderWrapper.checkGLError("setShaderTexture");
    }

    public static void activeTexture(int texture) {
        RenderSystem.m_69388_((int)texture);
        RenderWrapper.checkGLError("activeTexture");
    }

    public static void bindTextureForSetup(int id) {
        RenderSystem.m_157184_((int)id);
        RenderWrapper.checkGLError("bindTextureForSetup");
    }

    public static void bindTexture(int id) {
        RenderSystem.m_69396_((int)id);
        RenderWrapper.checkGLError("bindTexture");
    }

    public static void clear(int mask) {
        GlStateManager.m_84266_((int)mask, (boolean)Minecraft.f_91002_);
        RenderWrapper.checkGLError("clear");
    }

    public static void depthFunc(int func) {
        RenderSystem.m_69456_((int)func);
        RenderWrapper.checkGLError("depthFunc");
    }

    public static void colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        RenderSystem.m_69444_((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
        RenderWrapper.checkGLError("colorMask");
    }

    public static void setProjectionMatrix(Matrix4f matrix4f) {
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        RenderWrapper.checkGLError("setProjectionMatrix");
    }

    public static PoseStack getModelViewStack() {
        PoseStack stack = RenderSystem.m_157191_();
        RenderWrapper.checkGLError("getModelViewStack");
        return stack;
    }

    public static void lineWidth(float stroke) {
        RenderSystem.m_69832_((float)stroke);
        RenderWrapper.checkGLError("lineWidth");
    }

    public static boolean isTexture(int texture) {
        boolean isTexture = GL11C.glIsTexture((int)texture);
        RenderWrapper.checkGLError("isTexture");
        return isTexture;
    }

    public static void pixelStore(int pname, int param) {
        GL11C.glPixelStorei((int)pname, (int)param);
        RenderWrapper.checkGLError("pixelStore");
    }

    public static void texSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        GL11C.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static boolean checkGLError(String method) {
        if (errorCheck) {
            int err;
            boolean hasError = false;
            while ((err = RenderWrapper.getError()) != 0) {
                hasError = true;
                JMLogger.logOnce("GL Error in method: " + method + " ERROR: " + err, null);
                try {
                    for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                    }
                }
                catch (Exception e) {
                    Journeymap.getLogger().warn("GL Error Exception: ", (Throwable)e);
                }
            }
            return hasError;
        }
        return false;
    }
}

