/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.create;

import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerTileEntity;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.Jade;
import snownee.jade.addon.create.CreatePlugin;

public enum BlazeBurnerProvider implements IComponentProvider,
IServerDataProvider<BlockEntity>
{
    INSTANCE;


    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!config.get(CreatePlugin.BLAZE_BURNER)) {
            return;
        }
        CompoundTag compound = accessor.getServerData();
        BlazeBurnerTileEntity.FuelType activeFuel = BlazeBurnerTileEntity.FuelType.NONE;
        boolean isCreative = compound.m_128471_("isCreative");
        if (isCreative) {
            BlazeBurnerBlock.HeatLevel heatLevel = BasinTileEntity.getHeatLevelOf((BlockState)accessor.getBlockState());
            if (heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING) {
                activeFuel = BlazeBurnerTileEntity.FuelType.SPECIAL;
            } else if (heatLevel != BlazeBurnerBlock.HeatLevel.NONE) {
                activeFuel = BlazeBurnerTileEntity.FuelType.NORMAL;
            }
        } else {
            activeFuel = BlazeBurnerTileEntity.FuelType.values()[compound.m_128451_("fuelLevel")];
        }
        if (activeFuel == BlazeBurnerTileEntity.FuelType.NONE) {
            return;
        }
        IElementHelper elements = tooltip.getElementHelper();
        ItemStack item = new ItemStack((ItemLike)(activeFuel == BlazeBurnerTileEntity.FuelType.SPECIAL ? Items.f_42782_ : Items.f_42781_));
        tooltip.add(Jade.smallItem((IElementHelper)elements, (ItemStack)item));
        if (isCreative) {
            tooltip.append((Component)new TranslatableComponent("jade.infinity"));
        } else {
            tooltip.append((Component)new TranslatableComponent("jade.seconds", new Object[]{compound.m_128451_("burnTimeRemaining") / 20}));
        }
    }

    public void appendServerData(CompoundTag data, ServerPlayer player, Level level, BlockEntity blockEntity, boolean details) {
        BlazeBurnerTileEntity burner = (BlazeBurnerTileEntity)blockEntity;
        if (burner.isCreative()) {
            data.m_128379_("isCreative", true);
        } else if (burner.getActiveFuel() != BlazeBurnerTileEntity.FuelType.NONE) {
            data.m_128405_("fuelLevel", burner.getActiveFuel().ordinal());
            data.m_128405_("burnTimeRemaining", burner.getRemainingBurnTime());
        }
    }
}

